import request from "@/utils/request"

/**
 * @description 车辆管理-车辆信息 接口
 */

// 列表查询
export function getInfoList(queryParams){
    return request({
        url:'/vehicle/list',
        method:'get',
        params: queryParams
    })
}

// 添加
export function addInfo(postForm){
    return request({
        url:'/vehicle/add',
        method:'post',
        data: postForm
    })
}

// 修改
export function editInfo(postForm) {
    return request({
      url: '/vehicle/edit',
      method: 'put',
      data: postForm
    })
  }

// 删除
export function deleteInfo(ids) {
    return request({
      url: '/vehicle/delete/' + ids,
      method: 'delete'
    })
  }

// 根据主键查询详情
export function getInfo(id){
    return request({
        url:'/vehicle/getInfo/' + id,
        method:'get',
    })
}
