import request from "@/utils/request";

export function getList(queryParams, examId) {
  return request({
    url: `/examUser/list/${examId}`,
    method: 'get',
    params: queryParams
  })
}

export function listForAdding(queryParams, examId) {
  return request({
    url: `/examUser/addList`,
    method: 'get',
    params: {...queryParams,examId}
  })
}

export function selectedUserAppend(reqFormData, examId, userIds) {
  return request({
    url: `/examUser/add/${examId}/${userIds}`,
    method: 'post',
  })
}

export function deleteData(id) {
  return request({
    // url: `/examUser/delete/${ids}`,
    url: `/examUser/delete/${id}`,
    method: 'delete',
  })
}

// 导入
export function handleImport(excelFile, examId) {
  return request({
    url: `/examUser/importData/${examId}`,
    method: 'post',
    data: excelFile
  })
}


export class BackToFrontTransfer {
  constructor(data) {
    this.id = data.id
    ///关键部分///
    this.activityTitle = data.examName
    this.deptId = data.deptId
    this.department = data.deptName
    this.userId = data.userId
    this.user = data.userName
    this.idCard = data.idCard
    this.isLeader = data.isLeader
    this.examId = data.examId
    this.remark = data.remark
    this.phoneNumber = data.phoneNumber
  }
}
