import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listTurnover(query) {
  return request({
    url: '/studentTurnover/list',
    method: 'get',
    params: query
  })
}

// 查询详细
export function getTurnover(id) {
  return request({
    url: '/studentTurnover/queryById/' + id,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addTurnover(data) {
  return request({
    url: '/studentTurnover/add',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateTurnover(data) {
  return request({
    url: '/studentTurnover/edit',
    method: 'put',
    data: data
  })
}
// // 获取学生信息
// export function getAllInfo(id) {
//   return request({
//     url: '/school/student/queryAllInfo/' + id,
//     method: 'get',
//   })
// }

// 删除【请填写功能名称】
export function delTurnover(id) {
  return request({
    url: '/studentTurnover/delete/' + id,
    method: 'delete'
  })
}

// 终止
export function stop(id) {
  return request({
    url: `/studentTurnover/termination/${id}`,
    method: 'put'
  })
}
// 办结
export function finished(id, imgData) {
  return request({
    url: `/studentTurnover/finish/${id}`,
    method: 'put',
    params: imgData
  })
}
// 文件上传方法
export function commonUpload(file, callback = null) {
  return request({
    url: '/common/upload',
    method: 'post',
    data: file,
    onUploadProgress: progress => {
      callback && callback(progress)
    }
  })
}

// 身份证号获取信息
export function getInfo(idCard) {
  return request({
    url: `/school/student/queryAllInfoByidCard/${idCard}`,
    method: 'get'
  })
}
//获取监护人信息
export function getRelationship(id, relationship) {
  return request({
    url: `/school/student/queryByrelationship/${id}/${relationship}`,
    method: 'get'
  })
}
//获取班级树
export function getClassTree() {
  return request({
    url: `/schoolClass/getClassTree`,
    method: 'get'
  })
}


