import request from '@/utils/request'

// 查询学校年级级部列表
export function listGrade(query) {
  return request({
    url: '/schoolGrade/list',
    method: 'get',
    params: query
  })
}

// 查询学校年级级部详细
export function getGrade(id) {
  return request({
    url: '/schoolGrade/getInfo/' + id,
    method: 'get'
  })
}

// 新增学校年级级部
export function addGrade(data) {
  return request({
    url: '/schoolGrade/add',
    method: 'post',
    data: data
  })
}

// 修改学校年级级部
export function updateGrade(data) {
  return request({
    url: '/schoolGrade/edit',
    method: 'put',
    data: data
  })
}

// 删除学校年级级部
export function delGrade(ids) {
  return request({
    url: '/schoolGrade/delete/' + ids,
    method: 'delete'
  })
}

// 升级
export function upgrade() {
  return request({
    url: '/schoolGrade/upgrade',
    method: 'put'
  })
}

