/**
 * @description 学生选科: 当前不可用
 * */
import request from "@/utils/request";

// 查看已选科的学生
/**
 * @param 班级id
 * */
export function getSelectedStudent(queryParams) {
  return request({
    url: `/studentSection/list/select/${ queryParams.classId }`,
    method: 'get',
    params: queryParams
  })
}

// 查看未选科的学生
/**
 * @param 班级id
 * */
export function getSelectingStudent(queryParams) {
  return request({
    url: `/studentSection/list/noSelect/${ queryParams.classId }`,
    method: 'get',
    params: queryParams
  })
}

// 老师设置学生选科情况
/**
 * @param studendId 学生id
 * @param sectionType 选科套餐
 * */

export function handleSection({ studentId, sectionType }) {
  return request({
    url: `/studentSection/edit`,
    method: 'put',
    data: {
      studentId,
      sectionType
    }
  })
}


