import request from '@/utils/request'

// 查询德育列表
export function listEdu() {
  return request({
    url: '/school/educationRule/list',
    method: 'get',
  })
}

// 查询德育详细
export function getEduDetail(id) {
  return request({
    url: '/school/educationRule/queryOne/' +id,
    method: 'get'
  })
}

// 新增德育
export function addEdu(data) {
  return request({
    url: '/school/educationRule/add',
    method: 'post',
    data: data
  })
}

// 修改德育
export function updateEdu(data) {
  return request({
    url: '/school/educationRule/edit',
    method: 'put',
    data: data
  })
}

// 删除德育
export function delEdu(ids) {
  return request({
    url: '/school/educationRule/delete/' + ids,
    method: 'delete'
  })
}
