import request from '@/utils/request'

// 查询学生德育检查列表
export function listEducation(query) {
  return request({
    url: '/integral/list/' + query.studentId,
    method: 'get',
    params: query
  })
}

// 查询学生德育检查详细
export function getEducation(id) {
  return request({
    url: '/integral/getInfo/' + id,
    method: 'get'
  })
}

// 新增学生德育检查
export function addEducation(data) {
  return request({
    url: '/integral/add',
    method: 'post',
    data: data
  })
}

// 修改学生德育检查
export function updateEducation(data) {
  return request({
    url: '/integral/edit',
    method: 'put',
    data: data
  })
}

// 删除学生德育检查
export function delEducation(id) {
  return request({
    url: '/integral/delete/' + id,
    method: 'delete'
  })
}
