import request from "@/utils/request";

/**
 * @description 学校资源库
 * */

// 列表查询
export function getList(queryForm) {
  return request({
    url: '/schoolResources/list',
    method: 'get',
    params: queryForm
  })
}

// 获取学校资源详情
export function getInfo(id) {
  return request({
    url: '/schoolResources/getInfo/' + id,
    method: 'get'
  })
}

// 新增学校资源
export function addResource(postForm) {
  return request({
    url: '/schoolResources/add',
    method: 'post',
    data: postForm
  })
}

// 修改学校资源
export function editResource(postForm) {
  return request({
    url: '/schoolResources/edit',
    method: 'put',
    data: postForm
  })
}

// 删除学校资源
export function deleteResource(ids) {
  return request({
    url: '/schoolResources/delete/' + ids,
    method: 'delete',
  })
}

