import request from "@/utils/request";
//查看设备领用列表
export function getReceive(query) {
  return request({
    url: "/receive/list",
    method: "get",
    params: query,
  });
}
//查看设备领用详细信息
export function queryReceive(id) {
  return request({
    url: "/receive/" + id,
    method: "get",
  });
}
//新增设备领用
export function addReceive(data) {
  return request({
    url: "/receive/add",
    method: "post",
    data,
  });
}
//修改设备领用
export function editReceive(data) {
  return request({
    url: "/receive/edit",
    method: "put",
    data: data,
  });
}
//删除设备领用
export function deleteReceive(id) {
  return request({
    url: "/receive/delete/" + id,
    method: "post",
  });
}

