import request from '@/utils/request'

// 查询值班管理列表
export function listDuty(id,query) {
  return request({
    url: '/dutyDetails/list/' + id,
    method: 'get',
    params: query
  })
}

// 查询值班管理详细
export function getDuty(id) {
  return request({
    url: '/dutyDetails/queryById/' + id,
    method: 'get'
  })
}

// 新增值班管理
export function addDuty(data,dutyId) {
  return request({
    url: '/dutyDetails/add/'+dutyId,
    method: 'post',
    data: data
  })
}

// 修改值班管理
export function updateDuty(data) {
  return request({
    url: '/dutyDetails/edit',
    method: 'put',
    data: data
  })
}

// 删除值班管理
export function delDuty(id) {
  return request({
    url: '/dutyDetails/delete/' + id,
    method: 'delete'
  })
}

//根据日期获取星期
export function getWeek(dutyDeDate) {
  return request({
    url: '/dutyDetails/getWeek/'+dutyDeDate,
    method: 'get'
  })
}

//获取值班人员列表
// export function teacherList() {
//   return request({
//     url: '/school/teacher/teacherList',
//     method: 'get'
//   })
// }

export function teacherList() {
  return request({
    url: '/school/teacher/getTeachers',
    method: 'get'
  })
}
