import request from '@/utils/request'

export function getAreaList(queryParams) {
    return request({
        url: '/area/list',
        method: 'get',
        params: queryParams
    })
}

export function addArea(data) {
    return request({
      url: '/area/add',
      method: 'post',
      data: data
    })
  }

  export function updateArea(data) {
    return request({
      url: '/area/edit',
      method: 'put',
      data: data
    })
  }

  export function delArea(id) {
    return request({
      url: '/area/delete/' + id,
      method: 'delete'
    })
  }

  export function getArea(id) {
    return request({
      url: '/area/queryById/' + id,
      method: 'get'
    })
  }
