import request from "@/utils/request";

// 新增获奖情况
export function addAward(data) {
  return request({
    url: "/award/add",
    method: "post",
    data: data,
  });
}
// 修改获奖情况
export function updateaAward(data) {
  return request({
    url: "/award",
    method: "put",
    data: data,
  });
}
//查询获奖情况列表
export function getAward(query) {
  return request({
    url: "/award/list",
    method: "get",
    params: query,
  });
}

// 查询获奖情况详情
export function listAward(ids) {
  return request({
    url: "/award/" + ids,
    method: "get",
  });
}

// 删除获奖情况
export function delAward(ids) {
  return request({
    url: "/award/" + ids,
    method: "delete",
  });
}
