import request from "@/utils/request";

/**
 * @description 采购申请 接口
 * */
//分管领导/主要领导下拉框
export function getLeaderList(data) {
  return request({
    url: '/school/teacherLeave/getSchoolLeader',
    method: 'get',
    params:data
  })
}

// 购买记录查询列表
export function purchaseList(queryForm) {
  return request({
    url: "/purchaseApproval/queryListApply",
    method: "get",
    params: queryForm
  })
}

// 按标题搜索采购记录
export function purchaseListByTitle(purchaseName) {
  return request({
    url: "/purchaseApproval/listApply/" + purchaseName,
    method: "get",
    params: purchaseName
  })
}

// 采购申请——提交申请
export function submitPurchaseList(id, applyUser) {
  return request({
    url: "/purchaseApproval/submitApply/" + id,
    method: "post",
    data: applyUser,
  })
}

//新增采购申请
export function addPurchaseList(data) {
  return request({
    url: "/purchaseApproval/addPurchase",
    method: "post",
    data,
  })
}

// 修改采购申请
export function editPurchaseList(data) {
  return request({
    url: "/purchaseApproval/editApply",
    method: "put",
    data,
  })
}

// 查询采购申请单条记录
export function getPurchaseListDetaial(id) {
  return request({
    url: "/purchaseApproval/listApplyOne/" + id,
    method: "get",
  })
}

// 删除采购申请
export function delPurchaseList(id) {
  return request({
    url: "/purchaseApproval/deletePurchase/" + id,
    method: "delete",
  })
}

//获取资产分类
export function getAssetsType() {
  return request({
    url: "/schoolAssetsType/typeTree",
    method: "get",
  })
}

// 获取部门
export function getDeptTree() {
  return request({
    url: "/system/user/deptTree",
    method: "get",
  })
}

// 获取批复项目
export function getBudgetList1(data) {
  return request({
    url: "/budget/getList",
    method: "get",
    params: data
  })
}

export {getLeaderList as teacherListInform}
