import request from '@/utils/request'

// 查询办公申购列表
export function listPurchase(query) {
  return request({
    url: '/purchase/list',
    method: 'get',
    params: query
  })
}

// 查看审批进度
export function getPurchase(id) {
  return request({
    url: `/purchase/getInfo/${id}`,
    method: 'get'
  })
}

// 新增办公申购
export function addPurchase(data) {
  return request({
    url: '/purchase/add',
    method: 'post',
    data: data
  })
}

// 修改办公申购
export function updatePurchase(data) {
  return request({
    url: '/purchase/edit',
    method: 'put',
    data: data
  })
}

// 删除办公申购
export function delPurchase(id) {
  return request({
    url: `/purchase/delete/${id}`,
    method: 'delete'
  })
}

// 提交申请
export function summitAppliance(id) {
  return request({
    url: `/purchase/submitApply/${id}`,
    method: 'post'
  })
}

// 完成任务
export function FinishTask(taskId,instanceId) {
  return request({
    url: `/purchase/complete/${taskId}/${instanceId}`,
    method: 'get'
  })
}

// 查看审批历史
export function applyHistory(id) {
  return request({
    url: `/activiti/process/listHistory`,
    method: 'get'
  })
}

// 查看审批进度
export function applyProgressCheck(id) {
  return request({
    url: `/activiti/process/read-resource`,
    method: 'get'
  })
}

