import request from '@/utils/request'

export function getBudgetList(queryParams) {
  return request({
    url: '/budget/getList',
    method: 'get',
    params: queryParams
  })
}

export function addBudget(data) {
  return request({
    url: '/budget/add',
    method: 'post',
    data: data
  })
}

export function editBudget(data) {
  return request({
    url: '/budget/edit',
    method: 'put',
    data: data
  })
}

export function deleteBudget(id) {
  return request({
    url: '/budget/delete/' + id,
    method: 'delete',
  })
}

export function queryBudget(id) {
  return request({
    url: '/budget/queryById/' + id,
    method: 'get',
  })
}
