import request from '@/utils/request'

export function getClassList(queryParams){
    return request({
        url: '/schoolAssetsType/list',
        method: 'get',
        params: queryParams
    })
}

export function queryClass(id){
    return request({
        url: '/schoolAssetsType/getInfo/' + id,
        method: 'get',
    })
}

export function addClass(form){
    return request({
        url: '/schoolAssetsType/add',
        method: 'post',
        data: form
    })
}

export function editClass(data){
    return request({
        url: '/schoolAssetsType/edit',
        method: 'put',
        data: data
    })
}

export function deleteClass(id){
    return request({
        url: '/schoolAssetsType/delete/' + id,
        method: 'delete'
    })
}
