import request from "@/utils/request";

//新增实验室
export function addSchoolLab(data) {
  return request({
    url: "/schoolLab/add",
    method: "post",
    data,
  });
}

// 查询实验室列表
export function getSchoolLab(query) {
  return request({
    url: "/schoolLab/list",
    method: "get",
    params: query,
  });
}
// 查看实验室详情

export function getSchoolLabxq(id) {
  return request({
    url: "/schoolLab/" + id,
    method: "get",
  });
}

// 修改实验室
export function updateSchoolLab(data) {
  return request({
    url: "/schoolLab/edit",
    method: "put",
    data,
  });
}
// 删除实验室
export function deleteSchoolLab(id) {
  return request({
    url: "/schoolLab/" + id,
    method: "post",
  });
}
//负责人下拉框
export function departUser() {
  return request({
    url: "/schoolLab/getLabAdmin",
    method: "get",
  });
}
//学科下拉框
export function subSchoolLab() {
  return request({
    url: "/schoolLab/getSub",
    method: "get",
  });
}
//查看班级完成详情
export function getClassDetails(query) {
  return request({
    url: "/schoolTeacherLabApply/getLabUserDetial",
    method: "get",
    params: query,
  });
}
