import request from '@/utils/request'

// 查询兴趣班详情列表
export function listInterestDetails(query,interestClassesId) {
  return request({
    url: '/interestDetails/list/' + interestClassesId,
    method: 'get',
    params: query
  })
}

// 查询兴趣班详情详细
export function getInterestDetails(id) {
  return request({
    url: '/interestDetails/getInfo/' + id,
    method: 'get'
  })
}

// 新增兴趣班详情
export function addInterestDetails(data,id) {
  return request({
    url: '/interestDetails/add/' + id,
    method: 'post',
    data: data
  })
}

// 修改兴趣班详情
export function updateInterestDetails(data) {
  return request({
    url: '/interestDetails/edit',
    method: 'put',
    data: data
  })
}

// 删除兴趣班详情
export function delInterestDetails(ids) {
  return request({
    url: '/interestDetails/delete/' + ids,
    method: 'delete'
  })
}
