import request from '@/utils/request'

// 查询兴趣班考勤信息列表
export function listClassAttendance(query,interestClassesId) {
  return request({
    url: '/interestAttendance/list/' + interestClassesId,
    method: 'get',
    params: query
  })
}

// 查询兴趣班考勤信息详细
export function getClassAttendance(id) {
  return request({
    url: '/interestAttendance/getInfo/' + id,
    method: 'get'
  })
}

// 新增兴趣班考勤信息
export function addClassAttendance(data,interestClassesId) {
  return request({
    url: '/interestAttendance/add/' + interestClassesId,
    method: 'post',
    data: data
  })
}

// 修改兴趣班考勤信息
export function updateClassAttendance(data) {
  return request({
    url: '/interestAttendance/edit',
    method: 'put',
    data: data
  })
}

// 删除兴趣班考勤信息
export function delClassAttendance(ids) {
  return request({
    url: '/interestAttendance/delete/' + ids,
    method: 'delete'
  })
}
