import request from "@/utils/request";

//人员分组

//获取分组集合

export function getUserList(query) {
  return request({
    url: `/notification/list`,
    method: "get",
    params: query,
  });
}
//修改详情
export function getXg(id) {
  return request({
    url: `/notification/selectOne/${id}`, // 在这里使用正确的拼接方式
    method: "get",
  });
}

// 根据分类id获取人员信息
export function getUser(notificationId) {
  return request({
    url: `/notification/getUserList/${notificationId}`,
    method: "get",
  });
}

//新增数据
export function addNotification(data) {
  return request({
    url: "/notification/add",
    method: "post",
    data,
  });
}

//分组新增人员;
export function addUser(data) {
  return request({
    url: "/notification/addNotificationUser",
    method: "post",
    data,
  });
}

//删除人员
export function deleteUser(data) {
  return request({
    url: "/notification/delectNotificationUser",
    method: "put",
    data,
  });
}

//修改分组信息
export function updateNotification(data) {
  return request({
    url: "/notification/update",
    method: "put",
    data,
  });
}

// 删除分组
export function deleteNotification(query) {
  return request({
    url: "/notification/deletes",
    method: "delete",
    params: query,
  });
}
