import request from "@/utils/request";

export function getList(queryParams) {
  return request({
    url: "/dcwj/list",
    method: 'get',
    params: queryParams
  })
}

export function addToList(reqFormData) {
  return request({
    url: "/dcwj/add",
    method: 'post',
    data: reqFormData
  })
}

export function editOnList(reqFormData) {
  return request({
    url: "/dcwj/edit",
    method: 'put',
    data: reqFormData
  })
}

export function deleteData(ids) {
  return request({
    url: `/dcwj/delete/${ids}`,
    method: 'delete',
  })
}

export function publishExam(id) {
  return request({
    url: `/dcwj/published/${id}`,
    method: 'put',
  })
}

export function recallExam(id) {
  return request({
    url: `/dcwj/withdraw/${id}`,
    method: 'put',
  })
}

export function getSchoolYear() {
  return request({
    url: `/schoolGrade/getNewYear`,
    method: 'get',
  })
}

export function getGrade() {
  return request({
    url: `/schoolGrade/getMemberGrade`,
    method: 'get',
  })
}

export function getGradeTree() {
  return request({
    url: `/schoolGrade/getUserGradeTree`,
    method: 'get',
  })
}

export class BackToFrontTransfer {
  constructor(whole) {
    class RowData {
      constructor(data) {
        this.id = data.id
        ///关键部分///
        this.gradeId = data.gradeId
        this.activityTitle = data.dcwjName
        this.note = data.dcwjMs
        this.status = data.dcwjZt
        this.startTime = data.dcwjKssj
        this.endTime = data.dcwjJssj
        this.schoolYear = data.schoolYear
        ///关键部分结束///
      }
    }

    console.log(whole)
    return whole.map(el => new RowData(el))
  }
}

export class FrontToBackTransfer {
  constructor(data) {
    this.id = data.id
    ///关键部分///
    this.gradeId = data.gradeId
    this.dcwjName = data.activityTitle
    this.dcwjZt = data.status
    this.dcwjKssj = data.startTime
    this.dcwjJssj = data.endTime
    this.schoolYear = data.schoolYear
    this.dcwjMs = data.note
    ///关键部分结束///
  }
}
