import request from "@/utils/request";

//获取实验名称下拉框
export function getLabplanxlk(query) {
  return request({
    url: "/schoolLabClassYear/getLab",
    method: "get",
    params: query,
  });
}
//新增年级实验室预约
export function addLabplan(data) {
  return request({
    url: "/schoolLabClassYear/add",
    method: "post",
    data,
  });
}
// 修改年级实验室预约
export function updateLabplan(data) {
  return request({
    url: "/schoolLabClassYear/edit",
    method: "put",
    data,
  });
}
//删除年级实验室预约
export function deleteLabplan(id) {
  return request({
    url: "/schoolLabClassYear/" + id,
    method: "post",
  });
}

// 查询年级实验室预约列表
export function getLabplanlist(query) {
  return request({
    url: "/schoolLabClassYear/list",
    method: "get",
    params: query,
  });
}

// 查询年级实验室详细信息
export function getLabplanxq(id) {
  return request({
    url: "/schoolLabClassYear/" + id,
    method: "get",
  });
}

//获取当前学年+学期
export function getSemester() {
  return request({
    url: "/experimentPlan/getSemester",
    method: "get",
  });
}
