import request from "@/utils/request";

//获取当前最新学年
export function getNewYear(data) {
  return request({
    url: "/schoolGrade/getNewYear",
    method: "get",
    data,
  });
}
// 查询级部
export function getGrade() {
  return request({
    url: "/experimentPlan/getGrade",
    method: "get",
  });
}
// 根据级部查询对应班级
export function getClass(id) {
  return request({
    url: "/experimentPlan/getClass/" + id,
    method: "get",
  });
}
//新增实验计划
export function addExperimentPlan(data) {
  return request({
    url: "/experimentPlan/add",
    method: "post",
    data,
  });
}
// 修改实验室
export function updateExperimentPlan(data) {
  return request({
    url: "/experimentPlan/edit",
    method: "put",
    data,
  });
}
// 查询实验计划列表
export function getExperimentPlan(query) {
  return request({
    url: "/experimentPlan/list",
    params: query,
  });
}
// 查询实验计划详细信息
export function getExperimentPlanxq(id) {
  return request({
    url: "/experimentPlan/" + id,
    method: "get",
  });
}

// 删除实验室
export function deleteExperimentPlan(id) {
  return request({
    url: "/experimentPlan/" + id,
    method: "post",
  });
}
//学科下拉框
export function subExperimentPlan(schoolYear) {
  return request({
    url: "/experimentPlan/getSub/" + schoolYear,
    method: "get",
  });
}
//获取当前学期
export function getSemester() {
  return request({
    url: "/experimentPlan/getSemester",
    method: "get",
  });
}
