import request from "@/utils/request";

// 获取成绩列表
export function performanceList(query) {
  return request({
    url: "/curricula/studentScore/list",
    method: "get",
    params: query,
  });
}

//根据学号获取学生信息
export function getInfoByschoolNo(query) {
  return request({
    url: `/curricula/studentScore/selectStudent?schoolNo=${query}`,
    method: "get",
  });
}

// 新增成绩
export function addPerformance(data) {
  return request({
    url: "/curricula/studentScore/add",
    method: "post",
    data,
  });
}

// 编辑成绩
export function editPerformance(data) {
  return request({
    url: "/curricula/studentScore/edit",
    method: "put",
    data,
  });
}

//删除成绩
export function deletePerformance(data) {
  return request({
    url: `/curricula/studentScore/delete/${data}`,
    method: "delete"
  });
}
