import request from "@/utils/request";

export function getList(queryParams, examId) {
  return request({
    url: `/epidemicUserScore/list/${examId}`,
    method: 'get',
    params: queryParams
  })
}

export class BackToFrontTransfer {
  constructor(data) {
    this.id = data.id
    ///关键部分///
    this.activityTitle = data.examName
    this.department = data.deptId
    this.deptName = data.deptName
    this.userId = data.userId
    this.name = data.name
    this.answerTime = data.answerTime
  }
}

export class FrontToBackTransfer {
  constructor(data) {
    this.id = data.id
    ///关键部分///
    this.examName = data.activityTitle
    this.deptId = data.department
    this.deptName = data.deptName
    this.userId = data.userId
    this.name = data.name
    this.answerTime = data.answerTime
  }
}
