import request from "@/utils/request";

/**
 * 学科设置 接口
 * */

// 查询学科列表
export function listSubject() {
  return request({
    url: '/curriculum/list',
    method: 'get',
  })
}

// 新增学科
export function addSubject(postForm) {
  return request({
    url: '/school/course/add',
    method: 'post',
    data: postForm
  })
}

// 查询学科
export function getSubjectDetail(id) {
  return request({
    url: '/school/course/queryOne/' + id,
    method: 'get'
  })
}

// 修改学科
export function editSubject(postForm) {
  return request({
    url: '/school/course/edit',
    method: 'put',
    data: postForm
  })
}

// 删除学科
export function delSubject(ids) {
  return request({
    url: '/school/course/delete/' + ids,
    method: 'delete'
  })
}
