import request from "@/utils/request";

/**
 * 班级管理 接口
 * */

//获取最新数据的年份
export function getNewYear() {
  return request({
    url: '/schoolGrade/getNewYear',
    method: 'get',
  })
}

/** 获取班级下拉列表 */
export function getClassTreeList(queryForm) {
  return request({
    url: '/schoolClass/getClassTreeForMentor',
    method: 'get',
    params: queryForm
  })
}

// 查询班级详情
export function getDetailInfo(id) {
  return request({
    url: '/schoolClass/queryOne/' + id,
    method: 'get'
  })
}

/** 获取学生列表 */
export function getStudentList(queryForm) {
  return request({
    url: '/schoolClass/getStudentList/' + queryForm.classId,
    method: 'get',
    params: queryForm
  })
}

/** 获取老师列表 */
export function getTeacherList(queryForm) {
  return request({
    url: '/schoolClass/getTeacherList/' + queryForm.classId,
    method: 'get',
    params: queryForm
  })
}

//获取家长信息
export function getParentInfo(studentId) {
  return request({
    url: '/school/mentor/parentList/' + studentId,
    method: 'get',
  })
}
