import request from '@/utils/request'

// 查询课堂巡检打分规则列表
export function listRule(query) {
  return request({
    url: '/schoolPatrolRule/list',
    method: 'get',
    params: query
  })
}

// 查询课堂巡检打分规则详细
// export function getRule(id) {
//   return request({
//     url: '/schoolPatrolRule/list/' + id,
//     method: 'get'
//   })
// }

// 新增课堂巡检打分规则
export function addRule(data) {
  return request({
    url: '/schoolPatrolRule/add',
    method: 'post',
    data: data
  })
}

// 修改课堂巡检打分规则
export function updateRule(data) {
  return request({
    url: '/schoolPatrolRule/edit',
    method: 'put',
    data: data
  })
}

// 删除课堂巡检打分规则
export function delRule(ids) {
  return request({
    url: '/schoolPatrolRule/delete/' + ids,
    method: 'delete',
    data: ids
  })
}

//导出表格选中行数据
export function exportPart(ids) {
  return request({
    url: '/schoolPatrolRule/export/' + ids,
    method: 'post',
    data: ids
  })
}

//导出表格所有数据
export function exportFull() {
  return request({
    url: '/schoolPatrolRule/export',
    method: 'post',
  })
}

