import request from "@/utils/request";

/**
 * 学生管理 接口
 * */

// 查询学生列表
export function listStudent(queryParams) {
  return request({
    url: '/school/headMaster/getStudentList',
    method: 'get',
    params: queryParams
  })
}

// 查询学生详细
export function getStudent(id) {
  return request({
    url: '/school/student/queryOne/' + id,
    method: 'get'
  })
}

// 修改学生-----
export function updateStudent(data) {
  return request({
    url: '/school/student/edit',
    method: 'put',
    data: data
  })
}


