import request from "@/utils/request";

export function getList(queryParams) {
  return request({
    url: `/dcwjNr/list/`,
    // url:`/dcwjNr/list`,
    method: 'get',
    params: queryParams
  })
}

export function findOne(id) {
  return request({
    url: `/dcwjNr/queryById/${id}`,
    method: 'get',
  })
}

export function addToList(reqFormData, examId) {
  return request({
    url: `/dcwjNr/add/`,
    method: 'post',
    data: {...reqFormData, dcwjId: examId}
  })
}

export function editOnList(reqFormData, examId) {
  return request({
    url: `/dcwjNr/edit/`,
    method: 'put',
    data: {...reqFormData, dcwjId: examId}
  })
}

export function deleteData(ids) {
  return request({
    url: `/dcwjNr/delete/${ids}`,
    method: 'delete',
  })
}

// 导入
export function handleImport(file, examId) {
  return request({
    url: `/dcwjNr/importData/${examId}`,
    method: 'post',
    data: file
  })
}


export class BackToFrontTransfer {
  constructor(whole) {
    class RowData {
      constructor(data) {
        this.examId = data.examId
        this.id = data.id
        this.sort = data.nrPx
        this.subjectType = data.nrLx
        this.subjectRequired = data.nrSfbt
        this.quizTitle = data.nrBt
        this.option = data.nr
      }
    }

    console.log(whole)
    return whole.map(item => new RowData(item))
  }
}

export class FrontToBackTransfer {
  constructor(data) {
    this.examId = data.examId
    this.id = data.id
    this.sort = data.sort
    this.subjectType = data.subjectType
    this.subjectTitle = data.quizTitle
    this.optionA = data.optionA
  }
}
