import request from "@/utils/request";
// 查看学生违纪列表(管理员)
export function listDiscipline(query) {
  return request({
    url: "/school/discipline/list",
    method: "get",
    params: query,
  });
}
//查看学生违纪列表(个人)
export function listDisciplinegr(query) {
  return request({
    url: "/school/discipline/listGr",
    method: "get",
    params: query,
  });
}
//查看详情
export function getDiscipline(id) {
  return request({
    url: "/school/discipline/" + id,
    method: "get",
  });
}

// 新增学生违纪(管理员)
export function addDiscipline(data) {
  return request({
    url: "/school/discipline/add",
    method: "post",
    data: data,
  });
}
// 新增学生违纪(个人)
export function addDisciplinegr(data) {
  return request({
    url: "/school/discipline/addGr",
    method: "post",
    data: data,
  });
}
// 编辑学生违纪
export function updateDiscipline(data) {
  return request({
    url: "/school/discipline/edit",
    method: "put",
    data: data,
  });
}
// 删除学生违纪
export function delDiscipline(ids) {
  return request({
    url: "/school/discipline/" + ids,
    method: "delete",
  });
}
//提交
export function subApply(data) {
  return request({
    url: "/school/discipline/submit",
    method: "put",
    data,
  });
}
// 获取最新三个年级
export function getGrade() {
  return request({
    url: "/school/discipline/getGrade",
    method: "get",
  });
}

// 根据年级获取班级
export function getClassList(query) {
  return request({
    url: "/school/discipline/getClassList",
    method: "get",
    params: query,
  });
}
// 查看学生违纪(查看已通过)
export function listDisciplinetg(query) {
  return request({
    url: "/school/discipline/listTg",
    method: "get",
    params: query,
  });
}
//获取教师下拉框
export function getTeacher() {
  return request({
    url: "/schoolLabCompetition/getTeacher",
    method: "get",
  });
}
