import request from "@/utils/request";
// 新增学校获奖
export function addawards(data) {
  return request({
    url: "school/awards/add",
    method: "post",
    data: data,
  });
}
// 编辑学校获奖
export function updateAwards(data) {
  return request({
    url: "/school/awards/edit",
    method: "put",
    data: data,
  });
}

// 查看学校获奖列表
export function listAwards(query) {
  return request({
    url: "/school/awards/list",
    method: "get",
    params: query,
  });
}

//查看详情
export function getAwards(id) {
  return request({
    url: "/school/awards/" + id,
    method: "get",
  });
}

// 删除学校获奖信息
export function delAwards(ids) {
  return request({
    url: "/school/awards/" + ids,
    method: "delete",
  });
}
//提交
export function subApply(data) {
  return request({
    url: "/school/awards/submit",
    method: "put",
    data,
  });
}
// 组织机构下拉框
export function getdeptTree() {
  return request({
    url: "/system/user/deptTree",
    method: "get",
  });
}

//获取部门主任
export function getDeptLeader(form) {
  return request({
    url: "/school/teacherLeave/getDeptLeader/" + form.competentDeptId,
    method: "get",
    params: form, // 这里使用 params 传递参数
  });
}

// 新增学校获奖(个人)
export function addawardsgr(data) {
  return request({
    url: "/school/awards/addGr",
    method: "post",
    data: data,
  });
}
// 查看学校获奖列表(个人)
export function listAwardsgr(query) {
  return request({
    url: "/school/awards/listGr",
    method: "get",
    params: query,
  });
}
// 查看学校获奖列表(查看已通过)
export function listAwardstg(query) {
  return request({
    url: "/school/awards/listTg",
    method: "get",
    params: query,
  });
}
