import request from '@/utils/request'

// 查询学校场地申请列表
export function listApply(query) {
  return request({
    url: '/areaApply/list',
    method: 'get',
    params: query
  })
}

// 查询学校场地申请详细
export function getApply(id) {
  return request({
    url: '/areaApply/queryById/' + id,
    method: 'get'
  })
}
//提交申请
export function subApply(id) {
  return request({
    url: '/areaApply/submitApply/' + id,
    method: 'post',
  })
}

// 新增学校场地申请
export function addApply(data) {
  return request({
    url: '/areaApply/add',
    method: 'post',
    data: data
  })
}

// 修改学校场地申请
export function updateApply(data) {
  return request({
    url: '/areaApply/edit',
    method: 'put',
    data: data
  })
}

// 删除学校场地申请
export function delApply(id) {
  return request({
    url: '/areaApply/deleteByIds/' + id,
    method: 'delete'
  })
}

// 处理任务
export function complete({taskId, instanceId, comment, pass}) {
  return request({
    url: `/areaApply/complete/${taskId}/${instanceId}`,
    method: 'post',
    data: {
      comment,
      pass
    }
  })
}



