// 社团成员管理
import request from '@/utils/request';

// 查询社团成员管理
export function getMemberInfo(query) {
  return request({
    url: '/member/list',
    method: 'get',
    params: query
  })
}


// 查询社团成员管理信息列表
export function listMemberInfo(id) {
  return request({
    url: '/member/'+ id,
      method: 'get',
  
  })
}

// 修改社团成员管理
export function editMemberInfo(data) {
  return request({
    url: '/member',
      method: 'put',
       data: data
  })
}


// 新增社团成员管理
export function addMemberInfo(data) {
  return request({
    url: '/member',
    method: 'post',
    data: data
  })
}


// 删除社团成员管理
export function delMemberInfo(id) {
  return request({
    url: '/member/'+ id,
    method: 'delete'
  })
}


// 获取全校教师(不分页)
export function getTeachers(data) {
  return request({
    url: '/school/teacher/getTeachers',
    method: 'get',
    params: data
  })
}