// 社团活动记录
import request from '@/utils/request';

// 查询社团活动记录列表
export function getClubInfo(data) {
  return request({
    url: '/record/list',
    method: 'get',
    params: data
  })
}


// 查询社团活动记录列表
export function listClubInfo(id) {
  return request({
    url: '/record/'+ id,
      method: 'get',
  
  })
}

// 修改社团活动记录
export function editClubInfo(data) {
  return request({
    url: '/record',
      method: 'put',
       data: data
  })
}


// 新增社团活动记录
export function addClubInfo(data) {
  return request({
    url: '/record',
    method: 'post',
    data: data
  })
}


// 删除社团活动记录
export function delClubInfo(id) {
  return request({
    url: '/record/'+ id,
    method: 'delete'
  })
}


// 获取全校教师(不分页)
export function getTeachers(data) {
  return request({
    url: '/school/teacher/getTeachers',
    method: 'get',
    params: data
  })
}