import request from "@/utils/request";

//新增仪器药品分类
export function addInst(data) {
  return request({
    url: "/schoolInstrumentClassify/add",
    method: "post",
    data,
  });
}
//修改仪器药品分类
export function editInst(data) {
  return request({
    url: "/schoolInstrumentClassify/edit",
    method: "put",
    data,
  });
}
//查询仪器药品分类列表
export function getList(query) {
  return request({
    url: "/schoolInstrumentClassify/list",
    method: "get",
    params: query,
  });
}

// 查看仪器药品分类详情
export function getInstxq(id) {
  return request({
    url: "/schoolInstrumentClassify/" + id,
    method: "get",
  });
}

//删除仪器药品分类
export function deleteInst(ids) {
  return request({
    url: "/schoolInstrumentClassify/" + ids,
    method: "post",
    data: ids,
  });
}

