package com.ruoyi.system.mapper;

import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用户表 数据层
 *
 * @author ruoyi
 */
public interface SysUserMapper {
    /**
     * 根据条件分页查询用户列表
     *
     * @param sysUser 用户信息
     * @return 用户信息集合信息
     */
    public List<SysUser> selectUserList(SysUser sysUser);

    public List<SysUser> selectUserListTypeLogin(SysUser sysUser);
    public List<SysUser> selectDeptAncetorsByPernId(String deptId);

    /**
     * 根据条件分页查询已配用户角色列表
     *
     * @param user 用户信息
     * @return 用户信息集合信息
     */
    public List<SysUser> selectAllocatedList(SysUser user);


    public List<String> selectDeptRoleBydeptId(String deptId);

    public List<String> selectDeptPlaceBydeptId(String deptId);

    /**
     * 根据条件分页查询未分配用户角色列表
     *
     * @param user 用户信息
     * @return 用户信息集合信息
     */
    public List<SysUser> selectUnallocatedList(SysUser user);

    /**
     * 通过用户名查询用户
     *
     * @param userName 用户名
     * @return 用户对象信息
     */
    public SysUser selectUserByUserName(String userName);

    /**
     * 通过用户ID查询用户
     *
     * @param userId 用户ID
     * @return 用户对象信息
     */
    public SysUser selectUserById(Long userId);

    /**
     * 新增用户信息
     *
     * @param user 用户信息
     * @return 结果
     */
    public int insertUser(SysUser user);

    /**
     * 修改用户信息
     *
     * @param user 用户信息
     * @return 结果
     */
    public int updateUser(SysUser user);

    /**
     * 修改用户头像
     *
     * @param userName 用户名
     * @param avatar   头像地址
     * @return 结果
     */
    public int updateUserAvatar(@Param("userName") String userName, @Param("avatar") String avatar);

    public int updateAvatar(@Param("userId") Long userId, @Param("avatar") String avatar);

    public int updateUserSign(@Param("userId") Long userId, @Param("sign") String sign);

    public int updateOpenId(@Param("userId") Long userId, @Param("openId") String openId);

    /**
     * 重置用户密码
     *
     * @param userName 用户名
     * @param password 密码
     * @return 结果
     */
    public int resetUserPwd(@Param("userName") String userName, @Param("password") String password);

    /**
     * 通过用户ID删除用户
     *
     * @param userId 用户ID
     * @return 结果
     */
    public int deleteUserById(Long userId);
    public SysUser selectUserByDdUserId(String ddUserId);

    /**
     * 批量删除用户信息
     *
     * @param userIds 需要删除的用户ID
     * @return 结果
     */
    public int deleteUserByIds(Long[] userIds);

    /**
     * 校验用户名称是否唯一
     *
     * @param userName 用户名称
     * @return 结果
     */
    public SysUser checkUserNameUnique(String userName);

    /**
     * 校验手机号码是否唯一
     *
     * @param phonenumber 手机号码
     * @return 结果
     */
    public SysUser checkPhoneUnique(String phonenumber);

    /**
     * 校验email是否唯一
     *
     * @param email 用户邮箱
     * @return 结果
     */
    public SysUser checkEmailUnique(String email);

    /**
     * 通过用户名查询用户
     *
     * @param loginName 用户名
     * @return 用户对象信息
     */
    public SysUser selectUserByLoginName(String loginName);

    /**
     * @param key
     * @return
     */
    List<SysUser> selectUserListByRoleKey(String key);

    /**
     * @param roleKey
     * @param user
     * @return List<SysUser>
     * @author lyric
     * @date 2022/10/21 16:39
     */
    List<SysUser> getUserListByRoleKey(@Param("user") SysUser user, @Param("roleKey") String roleKey);



    /**
     *
     * @author lyric
     * @date 2022/10/27 19:09
     * @param userId
     * @return String
     * 根据userId查询userName
     */
    String selectUserNameByUserId(Long userId);

    /**
     *
     * @author lyric
     * @date 2022/10/31 19:29
     * @param userId
     * @return String
     * 根据userI 查询 openId
     */
    String selectOpenIdByUserId(Long userId);

    /**
     *
     * @author lyric
     * @date 2022/11/3 10:19
     * @param phonenumber
     * @return SysUser
     *
     * 根据电话号码查询用户
     */
    SysUser selectUserByPhonenumber(String phonenumber);

    SysUser selectUserByPhone(@Param("phonenumber") String phonenumber,
                                    @Param("userLoginType") String userLoginType);

    int removeUserByIds( List<Long> userIds);

    SchoolTeacher selectTeacherByUserId(Long userId);

    /**
     *
     * 根据职工类型+手机号查询用户
     */
    SysUser getUser(SysUser user);


    /**
     * 获取所在科室人员
     */
    List<SysUser> getDeptUserList(SysUser user);

    //根据id修改用户名
    int updateUserNameByUserId(@Param("userName") String userName,
                               @Param("userId") Long userId);

    /**
     * 更新用户表
     * @param updateUserList
     */
    void updateUserList(@Param("list") List<SysUser> updateUserList);
//    新增用户表
    void addUserList(@Param("list") List<SysUser> addUserList);
}
