package com.ruoyi.system.mapper;

import com.ruoyi.system.domain.SysUserDept;

import java.util.List;

public interface SysUserDeptMapper {

    /**
     * 通过用户ID删除用户和部门关联
     *
     * @param userId 用户ID
     * @return 结果
     */
    public int deleteUserDeptByUserId(Long userId);

    /**
     * 通过部门ID查询部门使用数量
     *
     * @param deptId 部门ID
     * @return 结果
     */
    public int countUserDeptById(Long deptId);

    /**
     * 批量删除用户和部门关联
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteUserDept(Long[] ids);

    /**
     * 批量新增用户部门信息
     *
     * @param userDeptList 用户部门列表
     * @return 结果
     */
    public int batchUserDept(List<SysUserDept> userDeptList);

    int saveUserDept(SysUserDept userDept);
}
