package com.ruoyi.quartz.task;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.ruoyi.common.utils.StringUtils;
import yangtz.cs.liu.dingding.controller.DingJiaXiaoController;
import yangtz.cs.liu.dingding.controller.dingClock.DingClockController;
import yangtz.cs.liu.dingding.controller.dingDept.DdDeptController;
import yangtz.cs.liu.dingding.controller.dingUser.DingUserController;

/**
 * 定时任务调度测试
 *
 * @author ruoyi
 */
@Component("ryTask")
public class RyTask
{
    @Autowired
    DingJiaXiaoController dingJiaXiaoController;
    @Autowired
    DdDeptController ddDeptController;
    @Autowired
    DingUserController dingUserController;
    @Autowired
    DingClockController dingClockController;

    public void ryMultipleParams(String s, Boolean b, Long l, Double d, Integer i)
    {
        System.out.println(StringUtils.format("执行多参方法： 字符串类型{}，布尔类型{}，长整型{}，浮点型{}，整形{}", s, b, l, d, i));
    }

    public void ryParams(String params)
    {
        System.out.println("执行有参方法：" + params);
    }

    public void ryNoParams()
    {
        System.out.println("执行无参方法");
    }

    //家校通讯录部门更新
    public void updateLabClassYear(){
        dingJiaXiaoController.updateLabClassYear();
    }

    //家校通讯录人员更新
    public void updateLabUser()throws Exception{
        dingJiaXiaoController.updateLabUser() ;
    }

    //钉钉通讯录更新
    public void syncDdDept(){
        ddDeptController.syncDdDept();
    }

    //钉钉用户更新
    public void syncDdUser(){
        dingUserController.syncDdUser();
    }

    //获取钉钉用户一周内打卡记录
    public void getListRecord(){
        dingClockController.getListRecord();
    }

    //获取钉钉用户一周内请假记录
    public void getTeacherLeave(){
        dingClockController.getTeacherLeave();
    }

}
