package com.ruoyi.framework.security.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.model.MpLoginUser;
import com.ruoyi.common.core.domain.model.WebLoginBody;
import com.ruoyi.framework.util.UserInfoUtil;
import com.ruoyi.framework.util.WebStudentInfoUtil;
import com.ruoyi.framework.web.service.MpTokenService;
import com.ruoyi.framework.web.service.WebTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.web.service.TokenService;

/**
 * token过滤器 验证token有效性
 *
 * @author ruoyi
 */
@Component
public class JwtAuthenticationTokenFilter extends OncePerRequestFilter
{
    @Autowired
    private TokenService tokenService;

    @Autowired
    private MpTokenService mpTokenService;

    @Autowired
    UserInfoUtil userInfoUtil;

    @Autowired
    private WebTokenService webTokenService;

    @Autowired
    WebStudentInfoUtil studentInfoUtil;

    /**
     *
     * @author lyric
     * @date 2022/10/19 9:01
     *
     * 增加公众号校验token
     *
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain)
            throws ServletException, IOException
    {
        String mpToken = mpTokenService.getToken(request);
        if (StringUtils.isNotEmpty(mpToken)) {
            //公众号登录
            MpLoginUser mpLoginUser = mpTokenService.getMpLoginUser(mpToken);
            userInfoUtil.setMpLoginUser(mpLoginUser);
            if (StringUtils.isNotNull(mpLoginUser)) {
                mpTokenService.verifyToken(mpLoginUser);
                UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(mpLoginUser, null, null);
                authenticationToken.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication(authenticationToken);
            }
        }

        String webToken = webTokenService.getToken(request);
        if (StringUtils.isNotEmpty(webToken)) {
            //艺考生网页端登录
            WebLoginBody webLoginBody = webTokenService.getWebLoginBody(webToken);
            studentInfoUtil.setLoginBody(webLoginBody);
            if (StringUtils.isNotNull(webLoginBody)) {
                webTokenService.verifyToken(webLoginBody);
                UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(webLoginBody, null, null);
                authenticationToken.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication(authenticationToken);
            }
        }

        //网页端登录
        LoginUser loginUser = tokenService.getLoginUser(request);
        if (StringUtils.isNotNull(loginUser) && StringUtils.isNull(SecurityUtils.getAuthentication()))
        {
            tokenService.verifyToken(loginUser);
            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(loginUser, null, loginUser.getAuthorities());
            authenticationToken.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication(authenticationToken);
        }
        chain.doFilter(request, response);
    }
}
