package com.ruoyi.common.core.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

/*
 * 老师表实体
 * */
@Data
public class SchoolTeacher extends BaseEntity{
    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 照片路径
     */
    @Excel(name = "照片", cellType = Excel.ColumnType.IMAGE, height = 55, type = Excel.Type.EXPORT)
    private String picUrl;

    /**
     * 老师名称
     */
    @Excel(name = "老师名称")
    @NotBlank(message = "老师名字不能为空")
    private String teacherName;

    /**
     * 性别
     */
    @Excel(name = "性别", readConverterExp = "0=男,1=女")
    @NotBlank(message = "性别不能为空")
    private String sex;

    /**
     * 民族
     */
    @Excel(name = "民族")
    private String nation;

    /**
     * 工作编号
     */
    @Excel(name = "工作编号")
    private String teacherCode;

    /*
     * 系统表 用户id
     * */
    @TableField(exist = false)
    private Long userId;

    /**
     * 生日
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "生日", width = 25, dateFormat = "yyyy-MM-dd")
    private Date birthday;

    /**
     * 学历
     */
    @Excel(name = "学历", readConverterExp = "0=高中,1=专科,2=本科,3=研究生,4=硕士,5=博士",combo = {"高中","专科","本科","研究生","硕士","博士"})
    private String education;


    /**
     * 老师电话
     */
    @Excel(name = "老师电话")
    @NotBlank(message = "老师电话不能为空")
    private String teacherTel;

    /**
     * 身份证号
     */
    @Excel(name = "身份证号", width = 30)
    @NotBlank(message = "身份证号不能为空")
    private String idCard;

    /**
     * 家庭住址
     */
    @Excel(name = "家庭住址", width = 35)
    private String homeAddress;

    /*
     * 微信openid
     * */
    private String openId;

    /*
     * 钉钉用户unionId
     * */
    private String unionId;

    /*
     * 钉钉用户id
     * */
    private String ddUserId;

    //设备工号
    private String deviceNum;

    /**部门id**/
    @TableField(exist = false)
    private Long deptId;

    /**部门名称**/
    @TableField(exist = false)
    private String deptName;

    /** 密码 */
    @TableField(exist = false)
    private String password;

    /** 帐号状态（0正常 1停用） */
    //@Excel(name = "帐号状态", readConverterExp = "0=正常,1=停用")
    @TableField(exist = false)
    private String status;

    /**签名路径*/
    @TableField(exist = false)
    private String sign;

    /**头像**/
    @TableField(exist = false)
    private String avatar;

    /*职工类型**/
    @TableField(exist = false)
    private String employeeType;

    @TableField(exist = false)
    private String email;

    /** 父部门ID */
    @TableField(exist = false)
    private Long parentId;

    /** 父部门名称 */
    @TableField(exist = false)
    private String parentName;
}
