package com.core.utils;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

public class HolidayDateUtil {

    //时间格式化
    public final static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public final static SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");

    public final static SimpleDateFormat format3 = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);

    public final static SimpleDateFormat format4 = new SimpleDateFormat("HH:mm:ss");

    /**
     * 判断judgeTime 是否在time之后
     * time是否在judgeTime之前
     * @param time HH:mm:ss
     * @return
     */
    public static boolean timeCompare(String time,String judgeTime){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss");
        LocalTime localTime=LocalTime.parse(time,dtf);
        LocalTime jTime = LocalTime.parse(judgeTime,dtf);
        return jTime.isAfter(localTime);
    }

    //获取两时间段差值X.x时
    //参数类型yyyy-MM-dd HH:mm:ss
    public static String dateToStamp(String bgtime, String edtime) throws ParseException {
        DecimalFormat f = new DecimalFormat("#0.0");
        long nd = 1000 * 24 * 60 * 60;
        long nh = 1000 * 60 * 60;
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long from = simpleFormat.parse(bgtime).getTime();
        long to = simpleFormat.parse(edtime).getTime();
        double hours=(double)(to - from) % nd / nh;
        return f.format(hours);
    }

    //获取Double型字符串最后一位，并转换为Int,返回0.X
    public static double getLast(String s){
        String a = s.substring(s.length()-1);
        int b = Integer.parseInt(a);
        String c = "0." + b;
        double d = Double.parseDouble(c);
        return d;
    }

    /**
     * 根据日期获取 星期
     *
     * @param datetime
     * @return
     */
    public static Integer dateToWeekValue(String datetime) {
        Integer[] weekDays = {7, 1, 2, 3, 4, 5, 6};
        Calendar cal = Calendar.getInstance();
        Date date;
        try {
            date = format1.parse(datetime);
            cal.setTime(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //一周的第几天
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }



    /**
     * 传入格式：字符串"Sun Dec 31 06:01:02 CST 1899" 也有可能是“7:53:16”
     * 传出字符串：“06:01:02”
     * */
    public static String getTime(String time) throws ParseException {
        if(time.contains("CST")){
            DateFormat df = DateFormat.getTimeInstance();//只显示出时分秒
            Date date = (Date) HolidayDateUtil.format3.parse(time);
            String t = df.format(date);
            return t;
        }
        /*Date time1 = HolidayDateUtil.format4.parse(time);
        String t = HolidayDateUtil.format4.format(time1);*/
        return time;
    }
    //是否是休息日
    public static String isLawHoliday(String calendar, List<String> lawHolidays) throws Exception {
        isValidDate(calendar);
        if (lawHolidays.contains(calendar)) {
            return "-1";
        }
        return "0";
    }

/*
    public String checkDate(String date) throws Exception {
        if(isHoliday(date)){
            return "-1";
        }else{
            return "0";
        }
    }
*/

    /**
     * @author qyw
     * @description 校验字符串是否为指定的日期格式, 含逻辑严格校验, 2007/02/30返回false
     * @date Created in 21:06 2019/1/31
     **/
    private static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        // 指定日期格式为四位年/两位月份/两位日期，注意yyyy-MM-dd区分大小写；
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            // 设置lenient为false.
            // 否则SimpleDateFormat会比较宽松地验证日期，比如2007/02/29会被接受，并转换成2007/03/01
            format.setLenient(false);
            format.parse(str);
        } catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }


    /**
     * 判断某年某月有多少天
     *
     * @param year 年  "yyyy"
     * @param moun 月 "m"
     * @return
     */
    public static int daysMonth(int year, int moun) {
        switch (moun) {
            case 0:
                return 31;
            case 1:
                return ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0) ? 29 : 28;
            case 2:
                return 31;
            case 3:
                return 30;
            case 4:
                return 31;
            case 5:
                return 30;
            case 6:
                return 31;
            case 7:
                return 31;
            case 8:
                return 30;
            case 9:
                return 31;
            case 10:
                return 30;
            case 11:
                return 31;
            default:
                return 0;
        }
    }

    /**
     * 通过时间秒毫秒数判断两个时间的间隔
     *
     * @param tiny  开始时间
     * @param large 结束时间
     * @return 返回几天
     */
    public static int differentDaysByMillisecond(Date tiny, Date large) {
        if (format1.format(tiny).equals(format1.format(large))) {
            return 0;
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(tiny);
        c2.setTime(large);
        int result = c2.get(Calendar.DAY_OF_YEAR) - c1.get(Calendar.DAY_OF_YEAR);
    /*Double why = Double.valueOf((large.getTime() - tiny.getTime()))/(1000*3600*24);
    double d = Math.ceil(why);*/
        return result;
    }

    /**
     * 通过时间秒毫秒数判断两个时间的间隔
     *
     * @param tiny  开始时间
     * @param large 结束时间
     * @return 返回几小时
     */
    public static double differentHoursByMillisecond(Date tiny, Date large) {
        double hours = ((double) ((large.getTime() - tiny.getTime())) / (1000 * 3600));
        return hours;
    }

    /**
     * 时间格式yyyy-MM-dd HH:mm:ss
     *
     * @param start   当前年月开始时间 yyyy-MM-dd HH:mm:ss
     * @param end     当前年月结束时间 yyyy-MM-dd HH:mm:ss
     * @param startTime  请假开始时间 yyyy-MM-dd HH:mm:ss || yyyy-MM-dd
     * @param endTime   请假结束时间 yyyy-MM-dd HH:mm:ss || yyyy-MM-dd
     * @return
     */
    public static int judgeLeaveTime(Date start, Date end, Date startTime, Date endTime) {
        /**
         * 判断集中情况
         * 1.请假开始时间和结束时间都在本月份的
         * 2.开始时间在本月份，结束时间不在本月份
         * 3.开始时间不在本月份，结束时间在本月份
         * 4.开始时间和结束时间都不在本月份
         *
         * 5.开始时间和结束时间在本时间段之前或之后的，返回5，不属于本时间范围的请假
         */
        //开始请假时间在本月份内
        if(startTime.after(start) && startTime.before(end)){
            //1.请假结束时间也在本月内
            if(endTime.after(start) && endTime.before(end)){
                return 1;
            }else{
                //2.请假结束时间不在本月内
                return 2;
            }
        }else{
            //开始请假时间不在本月份内

            if((startTime.before(start) && endTime.before(start)) || (startTime.after(end) && endTime.after(end))){
                return 5;
            }
            else if(endTime.after(start) && endTime.before(end)){
                //3.结束时间在本月份
                return 3;
            }else{
                //4.请假结束时间不在本月内
                return 4;
            }

        }
    }





    /**
     * 时间格式yyyy-MM-dd HH:mm:ss
     *
     * @param start   请假开始时间 yyyy-MM-dd HH:mm:ss
     * @param end     请假结束时间 yyyy-MM-dd HH:mm:ss
     * @param startM  上班早晨开始时间 HH:mm:ss
     * @param endE    上班早晨结束时间 HH:mm:ss
     * @param startAf 上班下午开始时间 HH:mm:ss
     * @param endAf   上班下午结束时间 HH:mm:ss
     * @return
     */
    public static double calculateTimeHour(String start, String end, String startM, String endE, String startAf, String endAf, List<String> holidays) {
        if (start != null && end != null && startM != null && endE != null && startAf != null && endAf != null) {//确保时间格式正确和值存在
            try {
                Date dataStart = HolidayDateUtil.format.parse(start);
                Date dataEnd = HolidayDateUtil.format.parse(end);

                double hours = 0;
                int monthDays = -1;
                Calendar cal = Calendar.getInstance();
                cal.setTime(dataStart);
                int yearTime = cal.get(Calendar.YEAR);
                int mounthTime = cal.get(Calendar.MONTH);
                int dataTime = cal.get(Calendar.DAY_OF_MONTH);

                double lunchBreak;
                //开始时间与结束时间间隔天数
                int interval = differentDaysByMillisecond(dataStart, dataEnd);

                //判断这年这月有多少天
                monthDays = HolidayDateUtil.daysMonth(yearTime, mounthTime);
                //String开始结束时间
                //第一天请假开始时间
                String startDay = start.substring(start.lastIndexOf(" ") + 1, start.length() - 1);
                //最后一天请假结束时间
                String endDay = end.substring(end.lastIndexOf(" ") + 1, end.length() - 1);
                double totalDay = 0;//累积总共请假多少小时
                for (int i = 0; i <= interval; i++) {
                    //间隔0天 也就是 请假在一天之内
                    if (interval == 0) {
                        //是休息日
                        if (!"0".equals(isLawHoliday(yearTime + "-" + (((mounthTime + 1)) >= 10 ? (mounthTime + 1) : "0" + (mounthTime + 1)) + "-" + (dataTime >= 10 ? dataTime : "0" + dataTime), holidays))) {
                            System.out.println("" + yearTime + (((mounthTime + 1)) > 10 ? (mounthTime + 1) : "0" + (mounthTime + 1)) + (dataTime > 10 ? dataTime : "0" + dataTime) + "非工作日期不需要计算");
                            return 0;
                        }
                        //是工作日
                        String s = start.substring(0, 10) + " " + endE;
                        String s1 = start.substring(0, 10) + " " + startAf;
                        String s2 = start.substring(0, 10) + " " + startM;
                        String s3 = start.substring(0, 10) + " " + endAf;
                        //当天上午上班时间
                        Date dataMorning = HolidayDateUtil.format.parse(s2);
                        //当天下午下班时间
                        Date dataAfternoon = HolidayDateUtil.format.parse(s3);
                        //当天上午下班时间
                        Date dataCenter1 = HolidayDateUtil.format.parse(s);
                        //当天下午上班时间
                        Date dataCenter2 = HolidayDateUtil.format.parse(s1);

                        //开始时间在7点45前 结束时间：①7点45前 ②7点45到11点30 ③11点30到14点 ④14点到17点30 ⑤17点30后
                        if (dataStart.compareTo(dataMorning) <= 0) {
                            //则开始时间一律按7点45开始请假
                            if (dataEnd.compareTo(dataMorning) <= 0) {
                                hours = 0;
                                lunchBreak = 0;
                            } else if (dataEnd.compareTo(dataMorning) > 0 && dataEnd.compareTo(dataCenter1) <= 0) {
                                hours = differentHoursByMillisecond(dataMorning, dataEnd);
                                lunchBreak = 0;
                            } else if (dataEnd.compareTo(dataCenter1) > 0 && dataEnd.compareTo(dataCenter2) <= 0) {
                                hours = differentHoursByMillisecond(dataMorning, dataCenter1);
                                lunchBreak = 0;
                            } else if (dataEnd.compareTo(dataCenter2) > 0 && dataEnd.compareTo(dataAfternoon) <= 0) {
                                hours = differentHoursByMillisecond(dataMorning, dataEnd);
                                //中间有两个半小时的休息时间
                                lunchBreak = 2.5;
                            } else {
                                hours = 7.25;
                                lunchBreak = 0;
                            }
                        }

                        //开始时间在7点45到11点30 结束时间：②7点45到11点30 ③11点30到14点 ④14点到17点30 ⑤17点30后
                        else if (dataStart.compareTo(dataMorning) > 0 && dataStart.compareTo(dataCenter1) <= 0) {
                            if (dataEnd.compareTo(dataMorning) > 0 && dataEnd.compareTo(dataCenter1) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = 0;
                            } else if (dataEnd.compareTo(dataCenter1) > 0 && dataEnd.compareTo(dataCenter2) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = differentHoursByMillisecond(dataCenter1, dataEnd);
                            } else if (dataEnd.compareTo(dataCenter2) > 0 && dataEnd.compareTo(dataAfternoon) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = 2.5;
                            } else {
                                hours = differentHoursByMillisecond(dataStart, dataAfternoon);
                                lunchBreak = 2.5;
                            }
                        }
                        //开始时间在11点30到14点 结束时间： ③11点30到14点 ④14点到17点30 ⑤17点30后
                        else if (dataStart.compareTo(dataCenter1) > 0 && (dataStart.compareTo(dataCenter2)) <= 0) {
                            if (dataEnd.compareTo(dataCenter1) > 0 && dataEnd.compareTo(dataCenter2) <= 0) {
                                hours = 0;
                                lunchBreak = 0;
                            } else if (dataEnd.compareTo(dataCenter2) > 0 && dataEnd.compareTo(dataAfternoon) <= 0) {
                                hours = differentHoursByMillisecond(dataCenter2, dataEnd);
                                lunchBreak = 0;
                            } else {
                                hours = differentHoursByMillisecond(dataStart, dataAfternoon);
                                lunchBreak = differentHoursByMillisecond(dataStart, dataCenter2);
                            }
                        }
                        //开始时间在14点到17点30 结束时间： ④14点到17点30 ⑤17点30后
                        else if (dataStart.compareTo(dataCenter2) > 0 && dataStart.compareTo(dataAfternoon) <= 0) {
                            if (dataEnd.compareTo(dataCenter2) > 0 && dataEnd.compareTo(dataAfternoon) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = 0;
                            } else {
                                hours = differentHoursByMillisecond(dataStart, dataAfternoon);
                                lunchBreak = 0;
                            }
                        }
                        //开始时间在6点后
                        else {
                            hours = 0;
                            lunchBreak = 0;
                        }

                    } else {
                        //间隔超过一天
                        //dataTime是当前月的第几天
                        dataTime += (i == 0 ? 0 : 1);
                        if (dataTime > monthDays) {
                            mounthTime++;
                            dataTime = 1;
                            if (mounthTime > 11) {
                                yearTime++;
                                mounthTime = 0;
                                dataTime = 1;
                            }
                            monthDays = daysMonth(yearTime, mounthTime);
                        }

                        //判断是否是节假日
                        //是休息日
                        if (!"0".equals(isLawHoliday(yearTime + "-" + (((mounthTime + 1)) >= 10 ? (mounthTime + 1) : "0" + (mounthTime + 1)) + "-" + (dataTime >= 10 ? dataTime : "0" + dataTime), holidays))) {
                            System.out.println("" + yearTime + (((mounthTime + 1)) > 10 ? (mounthTime + 1) : "0" + (mounthTime + 1)) + (dataTime > 10 ? dataTime : "0" + dataTime) + "非工作日期不需要计算");
                            continue;
                        }
                        //非休息日

                        //请假时间段内每天的起始时间
                        String s1 = yearTime + "-" + (((mounthTime + 1)) >= 10 ? (mounthTime + 1) : "0" + (mounthTime + 1)) + "-" + (dataTime >= 10 ? dataTime : "0" + dataTime) + " " + (i == 0 ? startDay : startM);
                        String s2 = yearTime + "-" + (((mounthTime + 1)) >= 10 ? (mounthTime + 1) : "0" + (mounthTime + 1)) + "-" + (dataTime >= 10 ? dataTime : "0" + dataTime) + " " + (i == interval ? endDay : endAf);

                        //所处日期日期拼接上每天上下班时间
                        Date dateMorning = HolidayDateUtil.format.parse(s1.substring(0, 10) + " " + startM);
                        Date dateAfternoon = HolidayDateUtil.format.parse(s1.substring(0, 10) + " " + endAf);
                        Date dateCenter1 = HolidayDateUtil.format.parse(s1.substring(0, 10) + " " + endE);
                        Date dateCenter2 = HolidayDateUtil.format.parse(s1.substring(0, 10) + " " + startAf);

                        dataStart = HolidayDateUtil.format.parse(s1);
                        dataEnd = HolidayDateUtil.format.parse(s2);
                        //第一天 end为6点 判断开始时间 ①7点45前 ②7点45到11点30 ③11点30到14点 ④ 14点到17点30 ⑤ 17点30之后
                        if (i == 0) {
                            if (dataStart.compareTo(dateMorning) <= 0) {
                                hours = 7.25;
                                lunchBreak = 0;
                            } else if (dataStart.compareTo(dateMorning) > 0 && dataStart.compareTo(dateCenter1) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = 2.5;
                            } else if (dataStart.compareTo(dateCenter1) > 0 && dataStart.compareTo(dateCenter2) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = differentHoursByMillisecond(dateCenter1, dataStart);
                            } else if (dataStart.compareTo(dateCenter2) > 0 && dataStart.compareTo(dateAfternoon) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = 0;
                            } else {
                                hours = 0;
                                lunchBreak = 0;
                            }
                            //中间天 hours 为7.25 lunchBreak为0
                        } else if (i != 0 && i != interval) {
                            hours = 7.25;
                            lunchBreak = 0;
                            //最后一天 start为7点45 判断结束时间 ①7点45前 ②7点45到11点30 ③11点30到14点 ④ 14点到17点30 ⑤ 17点30之后
                        } else {
                            if (dataEnd.compareTo(dateMorning) <= 0) {
                                hours = 0;
                                lunchBreak = 0;
                            } else if (dataEnd.compareTo(dateMorning) > 0 && dataEnd.compareTo(dateCenter1) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = 0;
                            } else if (dataEnd.compareTo(dateCenter1) > 0 && dataEnd.compareTo(dateCenter2) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = differentHoursByMillisecond(dateCenter1, dataEnd);
                            } else if (dataEnd.compareTo(dateCenter2) > 0 && dataEnd.compareTo(dateAfternoon) <= 0) {
                                hours = differentHoursByMillisecond(dataStart, dataEnd);
                                lunchBreak = 2.5;
                            } else {
                                hours = 7.25;
                                lunchBreak = 0;
                            }
                        }
                    }
                    System.out.println(yearTime + "-" + (((mounthTime + 1)) > 10 ? (mounthTime + 1) : "0" + (mounthTime + 1)) + "-" + (dataTime >= 10 ? dataTime : "0" + dataTime) + " 请假：" + (hours - lunchBreak) + "小时");
                    totalDay += hours - lunchBreak;
                }
                System.out.println(totalDay);
                return totalDay;
            } catch (ParseException e) {
                e.printStackTrace();
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return -1;
    }

    /**
     * 时间格式yyyy-MM-dd
     *
     * @param start   请假开始时间 yyyy-MM-dd
     * @param end     请假结束时间 yyyy-MM-dd
     * @param startSort  请假开始日期，从第几节课开始请假 int
     * @param endSort   请假结束日期  请到第几节课
     * @param holidays 请假时间段内的休息日
     * @return
     */
    public static int courseNum(String start, String end, int startSort, int endSort, List<String> holidays ){
        if (start != null && end != null && StringUtils.isNotNull(startSort) && StringUtils.isNotNull(endSort) ) {//确保时间格式正确和值存在
            try {
                Date dataStart = HolidayDateUtil.format1.parse(start);
                Date dataEnd = HolidayDateUtil.format1.parse(end);

                int hours = 0;
                int monthDays = -1;
                Calendar cal = Calendar.getInstance();
                cal.setTime(dataStart);
                int yearTime = cal.get(Calendar.YEAR);
                int mounthTime = cal.get(Calendar.MONTH);
                int dataTime = cal.get(Calendar.DAY_OF_MONTH);

                //开始时间与结束时间间隔天数
                int interval = differentDaysByMillisecond(dataStart, dataEnd);

                //判断这年这月有多少天
                monthDays = HolidayDateUtil.daysMonth(yearTime, mounthTime);

                int totalDay = 0;//累积总共请假多少节课
                for (int i = 0; i <= interval; i++) {
                    //间隔0天 也就是 请假在一天之内
                    if (interval == 0) {
                        //是休息日
                        if (!"0".equals(isLawHoliday(yearTime + "-" + (((mounthTime + 1)) >= 10 ? (mounthTime + 1) : "0" + (mounthTime + 1)) + "-" + (dataTime >= 10 ? dataTime : "0" + dataTime), holidays))) {
                            return 0;
                        }
                        //是工作日
                        //请假节次是否合法
                        if(startSort > endSort){
                            return -1;
                        }
                        //当天从第2节请到第4节，算3节
                        hours = endSort - startSort + 1;
                    } else {
                        //间隔超过一天
                        //dataTime是当前月的第几天
                        dataTime += (i == 0 ? 0 : 1);
                        if (dataTime > monthDays) {
                            mounthTime++;
                            dataTime = 1;
                            if (mounthTime > 11) {
                                yearTime++;
                                mounthTime = 0;
                                dataTime = 1;
                            }
                            monthDays = daysMonth(yearTime, mounthTime);
                        }

                        //判断是否是节假日
                        //是休息日
                        if (!"0".equals(isLawHoliday(yearTime + "-" + (((mounthTime + 1)) >= 10 ? (mounthTime + 1) : "0" + (mounthTime + 1)) + "-" + (dataTime >= 10 ? dataTime : "0" + dataTime), holidays))) {
                            continue;
                        }
                        //非休息日
                        //请假时间段内每天的开始结束节次
                        int hStartSort = (i == 0 ? startSort : 1);
                        int hEndSort =  (i == interval ? endSort : 8);
                        //第一天 end为8
                        if (i == 0) {
                            hours = 8 - hStartSort + 1;
                            //中间天 hours 为8节课
                        } else if (i != 0 && i != interval) {
                            hours = 8;
                            //最后一天 请假节次
                        } else {
                            hours = hEndSort;
                        }
                    }
                    totalDay += hours;
                }
                return totalDay;
            } catch (ParseException e) {
                e.printStackTrace();
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return -1;
    }

    /**
     * 累积请假共多少天
     *
     * @param totalDay
     * @return totalDay < 24小时按小时算   totalDay >= 24小时按天算
     */
    public String totalDay(double totalDay) {
        if (totalDay > 24) {
            return (totalDay / 24) + "天";
        } else {
            return totalDay + "小时";
        }
    }

    /**
     *教工，根据请假天数，返回请假X天Y节课
     * */
    public static String dayCourse(double day) {
        //获取day整数部分
        int dayNum = (int)Math.floor(day);
        //获取小数部分，转化为节课数
        int course = (int)((day-dayNum)*8);
        String dayCourse = dayNum + "天" + course + "节课";
        return dayCourse;
    }

    /**
     * 计算加班时间 start第一次打卡时间，传的6:01:01这种格式，，end最后一次打卡时间，传的6:01:01这种格式，
     * 早自习开始monStart 06:30:00
     * 早自习结束morEnd 07:15:00
     * 上午上班amStart 07:45:00
     * 上午下班amEnd 11:30:00
     * 下午上班pmStart 14:00:00
     * 下午下班pmEnd 17:30:00
     * 晚上自习开始eveStart 18:30:00
     * 返回值，字符串XXXX.X
     * */
    public static String calculateOverHour(String start, String end, String theDate, String monStart,  String morEnd,
                                           String amStart, String amEnd, String pmStart, String pmEnd, String eveStart) {
        //累计加班多少小时
        double total = 0;
        double hours = 0;
        //7点15到7点45
        double lunchBreak1 = 0;
        //11点30到14点
        double lunchBreak2 = 0;
        //17点30到18点30
        double lunchBreak3 = 0;
        try {
                String startString = theDate + " " + start;
                String endString = theDate + " " + end;

                String msString = theDate + " " + monStart;
                String meString = theDate + " " + morEnd;
                String asString = theDate + " " + amStart;
                String aeString = theDate + " " + amEnd;
                String psString = theDate + " " + pmStart;
                String peString = theDate + " " + pmEnd;
                String esString = theDate + " " + eveStart;

                Date dateStart = HolidayDateUtil.format.parse(startString);
                Date dateEnd = HolidayDateUtil.format.parse(endString);

                Date dateMs = HolidayDateUtil.format.parse(msString);
                Date dateMe = HolidayDateUtil.format.parse(meString);
                Date dateAs = HolidayDateUtil.format.parse(asString);
                Date dateAe = HolidayDateUtil.format.parse(aeString);
                Date datePs = HolidayDateUtil.format.parse(psString);
                Date datePe = HolidayDateUtil.format.parse(peString);
                Date dateEs = HolidayDateUtil.format.parse(esString);

                /**
                 * 取两次打卡内有效时间。（7点15到7点45、  11点30到14点、17点30到18点30 这里边的时间算无效时间）
                 * */

                //开始时间在7点15前，结束时间) 〇06:30:00前 ①06:30:00 到7点15 ②7点15到7点45  ③7点45到11点30
                // ④11点30到14点 ⑤14点到17点30 ⑥17点30到18点30 ⑦18点30后
                if (dateStart.compareTo(dateMe) <= 0) {
                    //结束时间在06:30:00前
                    if (dateEnd.compareTo(dateMs) <= 0) {
                        hours = 0;
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateMs) > 0 && dateEnd.compareTo(dateMe) <= 0) {
                        // 结束时间 ①06:30:00 到7点15
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateMe) > 0 && dateEnd.compareTo(dateAs) <= 0) {
                        //②7点15到7点45(时长计算为第一次打卡时间到7.15)
                        hours = differentHoursByMillisecond(dateStart, dateMe);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateAs) > 0 && dateEnd.compareTo(dateAe) <= 0) {
                        //③7点45到11点30
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0.5;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateAe) > 0 && dateEnd.compareTo(datePs) <= 0) {
                        //④11点30到14点
                        hours = differentHoursByMillisecond(dateStart, dateAe);
                        lunchBreak1 = 0.5;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(datePs) > 0 && dateEnd.compareTo(datePe) <= 0) {
                        //⑤14点到17点30
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0.5;
                        lunchBreak2 = 2.5;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(datePe) > 0 && dateEnd.compareTo(dateEs) <= 0) {
                        //⑥17点30到18点30
                        hours = differentHoursByMillisecond(dateStart, datePe);
                        lunchBreak1 = 0.5;
                        lunchBreak2 = 2.5;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateEs) > 0) {
                        //⑦18点30后
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0.5;
                        lunchBreak2 = 2.5;
                        lunchBreak3 = 1.0;
                    }
                } else if (dateStart.compareTo(dateMe) > 0 && dateStart.compareTo(dateAs) <= 0) {
                    //开始时间在7点15到7点45 ，结束时间: ②7点15到7点45  ③7点45到11点30
                                   // ④11点30到14点 ⑤14点到17点30 ⑥17点30到18点30 ⑦18点30后
                    if(dateEnd.compareTo(dateMe) > 0 && dateEnd.compareTo(dateAs) <= 0){
                        //②7点15到7点45
                        hours = 0;
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    }else if (dateEnd.compareTo(dateAs) > 0 && dateEnd.compareTo(dateAe) <= 0) {
                        //③7点45到11点30(打卡时间从7.45到打卡结束时间)
                        hours = differentHoursByMillisecond(dateAs, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    }else if (dateEnd.compareTo(dateAe) > 0 && dateEnd.compareTo(datePs) <= 0) {
                        //④11点30到14点
                        hours = differentHoursByMillisecond(dateAs, dateAe);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(datePs) > 0 && dateEnd.compareTo(datePe) <= 0) {
                        //⑤14点到17点30
                        hours = differentHoursByMillisecond(dateAs, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 2.5;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(datePe) > 0 && dateEnd.compareTo(dateEs) <= 0) {
                        //⑥17点30到18点30
                        hours = differentHoursByMillisecond(dateAs, datePe);
                        lunchBreak1 = 0;
                        lunchBreak2 = 2.5;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateEs) > 0) {
                        //⑦18点30后
                        hours = differentHoursByMillisecond(dateAs, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 2.5;
                        lunchBreak3 = 1.0;
                    }
                } else if (dateStart.compareTo(dateAs) > 0 && dateStart.compareTo(dateAe) <= 0 ) {
                    //开始时间在7点45到11点30，结束时间:  ③7点45到11点30
                    // ④11点30到14点 ⑤14点到17点30 ⑥17点30到18点30 ⑦18点30后
                    if (dateEnd.compareTo(dateAs) > 0 && dateEnd.compareTo(dateAe) <= 0) {
                        //③7点45到11点30(打卡时间到打卡结束时间)
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    }else if (dateEnd.compareTo(dateAe) > 0 && dateEnd.compareTo(datePs) <= 0) {
                        //④11点30到14点
                        hours = differentHoursByMillisecond(dateStart, dateAe);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(datePs) > 0 && dateEnd.compareTo(datePe) <= 0) {
                        //⑤14点到17点30
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 2.5;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(datePe) > 0 && dateEnd.compareTo(dateEs) <= 0) {
                        //⑥17点30到18点30
                        hours = differentHoursByMillisecond(dateStart, datePe);
                        lunchBreak1 = 0;
                        lunchBreak2 = 2.5;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateEs) > 0) {
                        //⑦18点30后
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 2.5;
                        lunchBreak3 = 1.0;
                    }
                } else if (dateStart.compareTo(dateAe) > 0 && dateStart.compareTo(datePs) <= 0) {
                    //开始时间在11点30到14点，结束时间: ④11点30到14点 ⑤14点到17点30 ⑥17点30到18点30 ⑦18点30后
                    if (dateEnd.compareTo(dateAe) > 0 && dateEnd.compareTo(datePs) <= 0) {
                        //④11点30到14点
                        hours = 0;
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(datePs) > 0 && dateEnd.compareTo(datePe) <= 0) {
                        //⑤14点到17点30
                        hours = differentHoursByMillisecond(datePs, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(datePe) > 0 && dateEnd.compareTo(dateEs) <= 0) {
                        //⑥17点30到18点30
                        hours = differentHoursByMillisecond(datePs, datePe);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateEs) > 0) {
                        //⑦18点30后
                        hours = differentHoursByMillisecond(datePs, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 1.0;
                    }
                } else if (dateStart.compareTo(datePs) > 0 && dateStart.compareTo(datePe) <= 0) {
                    //开始时间在14点到17点30，结束时间: ⑤14点到17点30 ⑥17点30到18点30 ⑦18点30后
                    if (dateEnd.compareTo(datePs) > 0 && dateEnd.compareTo(datePe) <= 0) {
                        //⑤14点到17点30
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(datePe) > 0 && dateEnd.compareTo(dateEs) <= 0) {
                        //⑥17点30到18点30
                        hours = differentHoursByMillisecond(dateStart, datePe);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateEs) > 0) {
                        //⑦18点30后
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 1.0;
                    }
                } else if (dateStart.compareTo(datePe) > 0 && dateStart.compareTo(dateEs) <= 0) {
                    //开始时间在17点30到18点30，结束时间: ⑥17点30到18点30 ⑦18点30后
                    if (dateEnd.compareTo(datePe) > 0 && dateEnd.compareTo(dateEs) <= 0) {
                        //⑥17点30到18点30
                        hours = 0;
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    } else if (dateEnd.compareTo(dateEs) > 0) {
                        //⑦18点30后
                        hours = differentHoursByMillisecond(dateEs, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    }
                } else if (dateStart.compareTo(dateEs) > 0) {
                    //开始时间在18点30后，结束时间:  ⑦18点30后
                    if (dateEnd.compareTo(dateEs) > 0) {
                        //⑦18点30后
                        hours = differentHoursByMillisecond(dateStart, dateEnd);
                        lunchBreak1 = 0;
                        lunchBreak2 = 0;
                        lunchBreak3 = 0;
                    }
                }
                total += hours - lunchBreak1 - lunchBreak2 - lunchBreak3;

        }catch (Exception e)  {
            throw new RuntimeException(e);
            }
            DecimalFormat f = new DecimalFormat("#0.0");
            return f.format(total);
    }

    //获取当前所在学年
    public static int getSchoolYear(){
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int nowYear = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期
        int term = 1;
        //2-7为第二学期，8-1为第一学期
        //如果当前月份小于8月，则该学年应为当前年-1 到 当前年,例如当前年月为2023年7月，则该学年为2022-2023年的第二学期
        if (month < 8) {
            nowYear = nowYear - 1;
        }
        if (month >= 2 && month < 8) {
            term = 2;
        }
        return nowYear;
    }

    //获取当前所在学年
    public static Integer getTerm() {
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期为上学期
        int term = 0;
        //2-7为下学期，8-1为上学期
        if (month >= 2 && month < 8) {
            term = 1;
        }
        return term;
    }

    //根据传入入学年份判断是否毕业
    public static boolean isGraduation(String y) {
        //不是毕业
        boolean isGraduation = false;
        int enrollmentYear = Integer.parseInt(y);
        String res = null;
        int time_year;
        int time_month;
        Date time = new Date();  //2016 2017 2018 2019 2020
        res = format1.format(time);
        time_year=Integer.parseInt(res.substring(0,4));
        time_month=Integer.parseInt(res.substring(5,7));

        //处理时间超时
        if(enrollmentYear > time_year){
            //入学年份大于当前时间
            return isGraduation;
        }

        //相同年，但是月份还不到9月
        if(enrollmentYear == time_year){
            if(time_month<9){
                return isGraduation;
            }
            else if(time_month>=9){
                return isGraduation;
            }
        }

        if(time_year > enrollmentYear){
            int temp = time_year - enrollmentYear;//时差
            if(temp<=2){
                String []Class={"高一","高二","高三"};
                res="你现在是"+Class[temp-1];
                if(time_month<9){
                    return isGraduation;
                }else {
                    if(temp<2){//不是高三
                        return isGraduation;
                    }else if(temp==2 ){
                        //高三
                        return isGraduation;
                    }
                }
            } else if (temp == 3){
                //高三
                if(time_month<9){
                    //高三下学期
                    return isGraduation;
                }else {
                    //毕业了
                    isGraduation = true;
                    return isGraduation;
                }
            }else if(temp > 3){
                //毕业了
                isGraduation = true;
                return isGraduation;
            }
        }
        return isGraduation;
    }
}
