package yangtz.cs.liu.wechat.controller.vehicle;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.activiti.service.IProcessService;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicleApplication;
import yangtz.cs.liu.campus.service.vehicle.ISchoolVehicleApplicationService;
import yangtz.cs.liu.campus.vo.vehicle.VehicleApplicationVO;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.core.constant.ProcessCommon.ROLEKEY;
import static com.core.constant.ProcessDefinition.VEHICLEAPPLICATION;
import static yangtz.cs.liu.campus.constant.ProcessState.PASS;
import static yangtz.cs.liu.campus.constant.ProcessState.REFUSE;

/**
 * 用车申请Controller
 *
 * @author xu
 * @date 2022-09-29
 */
@RestController
@RequestMapping("/wx/vehicleApplication")
public class WxSchoolVehicleApplicationController extends BaseController {
    @Autowired
    private ISchoolVehicleApplicationService schoolVehicleApplicationService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private UserInfoUtil userInfoUtil;

    /**
     * 查询用车申请列表
     */
    @GetMapping("/list")
    public TableDataInfo list(VehicleApplicationVO vehicleApplicationVO) {
        startPage();
        vehicleApplicationVO.setState("1");
        List<VehicleApplicationVO> list = schoolVehicleApplicationService.queryList(vehicleApplicationVO);
        return getDataTable(list);
    }

    /**
     * 查询个人用车申请列表
     */
    @GetMapping("/arrylist")
    public TableDataInfo arrylist(VehicleApplicationVO vehicleApplicationVO) {
        startPage();
        vehicleApplicationVO.setApplicantId(getUserId());
        List<VehicleApplicationVO> list = schoolVehicleApplicationService.queryList(vehicleApplicationVO);
        return getDataTable(list);
    }
    /**
     * 获取用车申请详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolVehicleApplicationService.getInfo(id));
    }

    /**
     * 新增用车申请
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolVehicleApplication schoolVehicleApplication) {
        //schoolVehicleApplication.setType("vehicleApplication");
        //用车人姓名
        schoolVehicleApplication.setApplicantName(userInfoUtil.getTeacherName());
        return toAjax(schoolVehicleApplicationService.save(schoolVehicleApplication));
    }

    /**
     * 删除用车申请
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolVehicleApplicationService.removeByIds(ids));
    }

    /**
     * 新增，提交申请
     */
    @PostMapping("/submitApply")
    public AjaxResult submitApply(@RequestBody @Validated SchoolVehicleApplication schoolVehicleApplication) {
        //用车人姓名
        schoolVehicleApplication.setApplicantName(userInfoUtil.getTeacherName());
        schoolVehicleApplicationService.save(schoolVehicleApplication);

        String teacherName = userInfoUtil.getTeacherName();
//        schoolVehicleApplication.setApplyUser(teacherName);
        schoolVehicleApplication.setApplyTime(DateUtils.getNowDate());
        //设置流程角色组标识
//        Map<String, Object> map = new HashMap<>();
//        map.put(ROLEKEY, schoolVehicleApplication.getRoleKey());
        schoolVehicleApplication.setState("1");
        return toAjax(schoolVehicleApplicationService.updateById(schoolVehicleApplication));
    }

}
