package yangtz.cs.liu.wechat.controller.teacher;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherWages;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherWagesService;

import java.util.List;

@RestController
@RequestMapping("/wx/teacherWages")
public class WxSchoolTeacherWagesController extends BaseController {

    @Autowired
    private ISchoolTeacherWagesService schoolTeacherWagesService;

    /**
     * 老师工资列表
     *
     * @param schoolTeacherWages
     * @return
     */
    @GetMapping("/list/{teacherId}")
    public TableDataInfo list(@PathVariable("teacherId") Long teacherId, SchoolTeacherWages schoolTeacherWages) {
//        取指定老师id列表
        schoolTeacherWages.setTeacherId(teacherId);
        startPage();
        List<SchoolTeacherWages> list = schoolTeacherWagesService.queryList(schoolTeacherWages);
        return getDataTable(list);
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolTeacherWagesService.getById(id));
    }
}
