package yangtz.cs.liu.wechat.controller.schoolClass;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.file.ImageUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.introduce.SchoolPic;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentService;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherService;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;
import yangtz.cs.liu.wechat.vo.schoolClass.SchoolClassVo;
import yangtz.cs.liu.wechat.vo.schoolGrade.SchoolGradeVo;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 班级查看
 * @author xuten
 */
@RestController
@RequestMapping("/wx/schoolClass")
public class WxSchoolClassController extends BaseController {

    @Autowired
    private ISchoolClassService schoolClassService;

    @Autowired
    private UserInfoUtil userInfoUtil;

    @Autowired
    private ISchoolStudentService schoolStudentService;

    @Autowired
    private ISchoolTeacherService schoolTeacherService;
    @Value("${ruoyi.serverAddress}")
    private String serverAddress;

    @Value("${server.port}")
    private String port;


    /**
     * 家长查看班级信息
     *
     * @return
     */
    @GetMapping("/getUserClassByParent")
    public AjaxResult getUserClassByParent(Long studentId) {
        SchoolClass aClass = schoolClassService.getUserClassByParent(studentId);
        return AjaxResult.success(aClass);
    }

    /**
     * 家长查看该班级同学
     *
     * @return
     */
    @GetMapping("/getMemberByParent")
    public TableDataInfo getMemberByParent(Long studentId) {
        startPage();
        List<SchoolStudent> studentList = schoolStudentService.getMemberByParent(studentId);
        return getDataTable(studentList);
    }


    /**
     * 老师查看班级信息？
     *
     * @return
     */
    @GetMapping("/getUserClassByTeacher")
    public AjaxResult getUserClassByTeacher() {
        Long teacherId = userInfoUtil.getTeacherId();
        List<SchoolClassVo> schoolClassVoList = schoolClassService.getUserClassByTeacher(teacherId);
        return AjaxResult.success(schoolClassVoList);
    }

    @GetMapping("/getClassById/{classId}")
    public AjaxResult getClassById(@PathVariable("classId") Long classId) {
        return AjaxResult.success(schoolClassService.getById(classId));
    }

    /**
     * 老师根据班级id查看学生
     *
     * @param classId
     * @return
     */
    @GetMapping("/getMemberByClassId/{classId}")
    public TableDataInfo getMemberByClassId(@PathVariable("classId") Long classId, SchoolStudent student) {
        startPage();
        LambdaQueryWrapper<SchoolStudent> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolStudent::getClassId, classId)
                .like(isNotBlank(student.getStudentName()), SchoolStudent::getStudentName, student.getStudentName())
        ;
        List<SchoolStudent> list = schoolStudentService.list(lqw);
        for(SchoolStudent s : list){
            //图片路径不为空
            if(StringUtils.isNotNull(s.getAvatar()) && !"".equals(s.getAvatar())){
                String url = serverAddress+s.getAvatar();
                byte[] b = ImageUtils.readFile(url);
                //转为base64传过去
                String base64 = Base64.encodeBase64String(b);
                s.setAvatar("data:image/jpeg;base64,"+base64);
            }
        }
        return getDataTable(list);
    }

    /**
     * 老师修改（班级口号）
     *
     * @param schoolClass
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolClass schoolClass) {
        return toAjax(schoolClassService.updateById(schoolClass));
    }


    /**
     * 家长查看班级任课老师
     * @param classId 班级id
     * @return
     */
    @GetMapping("/getTeachers/{classId}")
    public AjaxResult getTeachers(@PathVariable("classId") Long classId){
        List<SchoolTeacherVO> teachers = schoolTeacherService.getTeachers(classId);
        return AjaxResult.success(teachers);
    }

    /**
     * 获取教师所在班级
     * */
    @GetMapping("/getTeacherClass/{userId}")
    public TableDataInfo getTeacherClass(@PathVariable("userId") Long userId){
        List<SchoolClassVo> list = schoolClassService.getTeacherClass(userId);
        return getDataTable(list);
    }
}
