package yangtz.cs.liu.wechat.controller.repic;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.recipe.SchoolRecipes;
import yangtz.cs.liu.campus.service.recipe.ISchoolRecipesService;

import java.util.ArrayList;
import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.ruoyi.common.utils.StringUtils.isNotEmpty;

@RestController
@RequestMapping("/wx/repic")
public class WxSchoolRepicController extends BaseController {

    @Autowired
    private ISchoolRecipesService schoolRecipesService;


    /**
     * @param date 当天食谱
     * @author
     * @date 2022/10/19 20:56
     */
    @GetMapping("/getDetail")
    public AjaxResult getDetail(String date) {
        LambdaQueryWrapper<SchoolRecipes> lqw = new LambdaQueryWrapper<>();
        lqw.eq(isNotEmpty(date), SchoolRecipes::getDate, date);
        SchoolRecipes schoolRecipes = schoolRecipesService.getOne(lqw);
        return AjaxResult.success(schoolRecipes);
    }

    /**
     * TODO 一周的食谱,传一个时间区间回来,根据区间查询当前区间的食谱
     */
    @GetMapping("/getRecipes")
    public AjaxResult getRecipes(String start,String end){
        LambdaQueryWrapper<SchoolRecipes> lqw = new LambdaQueryWrapper<>();
        lqw
                .apply(ObjectUtil.isNotNull(start),
                        "date_format(date,'%Y-%m-%d') >= date_format('" + start + "','%Y-%m-%d') ")
                .apply(ObjectUtil.isNotNull(end),
                        "date_format(date,'%Y-%m-%d') <= date_format('" + end + "','%Y-%m-%d') ");
        List<SchoolRecipes> list = schoolRecipesService.list(lqw);
        return AjaxResult.success(list);
    }

}
