package yangtz.cs.liu.wechat.controller.process;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.activiti.service.IProcessService;
import yangtz.cs.liu.campus.domain.purchase.SchoolPurchase;
import yangtz.cs.liu.campus.domain.student.SchoolStudentLeave;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherLeave;
import yangtz.cs.liu.campus.service.purchase.ISchoolPurchaseService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentLeaveService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentService;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherLeaveService;
import yangtz.cs.liu.campus.vo.purchase.SchoolPurchaseVo;
import yangtz.cs.liu.campus.vo.student.StudentLeaveVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherLeaveVO;
import yangtz.cs.liu.wechat.service.process.IProService;
import yangtz.cs.liu.wechat.vo.process.WxProcessVo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNull;
import static com.core.constant.ProcessDefinition.*;
import static yangtz.cs.liu.wechat.constant.ProcessTypeConstant.*;

@RestController
@RequestMapping("/wx/process")
public class ProController extends BaseController {

    @Autowired
    private ISchoolTeacherLeaveService schoolTeacherLeaveService;

    @Autowired
    private ISchoolPurchaseService schoolPurchaseService;

    @Autowired
    private ISchoolStudentLeaveService schoolStudentLeaveService;

    @Autowired
    private IProService proService;

    //获取当前用户待审批任务
    @GetMapping("/taskList/{userId}")
    public TableDataInfo taskList(@PathVariable("userId") String userId, WxProcessVo vo) {
        List<TeacherLeaveVO> teaLeaveList = new ArrayList<>();
        List<SchoolPurchaseVo> purchaseList = new ArrayList<>();
        List<StudentLeaveVO> studentLeaveList = new ArrayList<>();

        if(isNull(vo.getProcessType())){
            //教师请假
            teaLeaveList = schoolTeacherLeaveService.findTasks(TEACHERLEAVE, userId);
            //采购申请
            purchaseList = schoolPurchaseService.findTasks(PURCHASEREQUEST, userId);
            studentLeaveList = schoolStudentLeaveService.findTasks(STUDENTLEAVE, userId);
        } else if (vo.getProcessType().equals(TEALEAVE)) {
            teaLeaveList = schoolTeacherLeaveService.findTasks(TEACHERLEAVE, userId);
        } else if (vo.getProcessType().equals(PURCHASE)) {
            //采购申请
            purchaseList = schoolPurchaseService.findTasks(PURCHASEREQUEST, userId);
        }else if (vo.getProcessType().equals(STULEAVE)){
            //学生请假
            studentLeaveList = schoolStudentLeaveService.findTasks(STUDENTLEAVE, userId);
        }
        //制作公众号所需数据
        List<WxProcessVo> list = proService.getList(teaLeaveList,purchaseList,studentLeaveList);
//        List<WxProcessVo> collect = list.stream().distinct().collect(Collectors.toList());
        //根据instanceId相同的条件去重
        List<WxProcessVo> collect = list.stream()
                .collect(Collectors.collectingAndThen(
                        Collectors.toCollection(
                                () -> new TreeSet<>(
                                        Comparator.comparing(o -> o.getInstanceId()))), ArrayList::new));

        return getDataTable(collect);
    }


    /**
     * 获取当前用户审批的数量（首页）
     * @param userId 用户id
     * @return
     */
    @GetMapping("/getRunNum/{userId}")
    public AjaxResult getRunNum(@PathVariable("userId") String userId){
        return AjaxResult.success(proService.getRunNum(userId));
    }
}
