package yangtz.cs.liu.wechat.controller.organization;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationFc;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationInfo;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationMember;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationSignin;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationFcService;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationInfoService;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationMemberService;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationSigninService;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentService;
import yangtz.cs.liu.wechat.vo.organization.SchoolOrganizationInfoListVo;
import yangtz.cs.liu.wechat.vo.organization.SchoolOrganizationInfoVo;
import yangtz.cs.liu.wechat.vo.organization.WxOrganizationSigninVo;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @USER: liul   18266668098
 * @DATE: 2023/9/7 14:43
 * @DESCRIPTION: 移动端社团信息获取Controller
 */
@RestController
@RequestMapping("/wx/info")
public class WxSchoolOrganizationController extends BaseController {

    @Autowired
    private ISchoolOrganizationInfoService schoolOrganizationInfoService;

    @Autowired
    private ISchoolOrganizationSigninService schoolOrganizationSigninService;

    @Autowired
    private ISchoolOrganizationMemberService schoolOrganizationMemberService;

    @Autowired
    private ISchoolOrganizationFcService schoolOrganizationFcService;

    @Autowired
    private UserInfoUtil userInfoUtil;

    @Autowired
    private ISchoolStudentService schoolStudent;

    @Autowired
    private ISchoolClassService schoolClass;

    @Autowired
    private ISchoolGradeService schoolGrade;



    /**
     * 查询社团信息列表
     */
    @GetMapping("/getInfo")
    public AjaxResult getInfo()
    {
        ArrayList<SchoolOrganizationInfoListVo> myList = new ArrayList<>();
//        String studentName = userInfoUtil.getMpLoginUser().getStudentName();
//        String studentIdCard = userInfoUtil.getMpLoginUser().getStudentIdCard();
        Long userId = userInfoUtil.getMpLoginUser().getUserId();
        LambdaQueryWrapper<SchoolOrganizationInfo> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SchoolOrganizationInfo::getDelFlag,"0");
        wrapper.orderByDesc(SchoolOrganizationInfo::getCreateTime);
        List<SchoolOrganizationInfo> list = schoolOrganizationInfoService.list(wrapper);
        if (list!=null && list.size()>0){
            for (int i = 0; i < list.size(); i++) {
                SchoolOrganizationInfo info = list.get(i);
                Long id = info.getId();
                LambdaQueryWrapper<SchoolOrganizationMember> wrapper2 = Wrappers.lambdaQuery();
                wrapper2.eq(SchoolOrganizationMember::getCid,id)
                        .eq(SchoolOrganizationMember::getUserId,userId);
//                        .eq(StringUtils.isNotEmpty(studentName),SchoolOrganizationMember::getName,studentName)
//                        .eq(StringUtils.isNotEmpty(studentIdCard),SchoolOrganizationMember::getCardid,studentIdCard);
                SchoolOrganizationMember one = schoolOrganizationMemberService.getOne(wrapper2);
                SchoolOrganizationInfoListVo vo = new SchoolOrganizationInfoListVo();
                BeanUtils.copyProperties(info,vo);
                if (one!=null){
                    vo.setIsattend("1");//表示已加入该社团
                }else {
                    vo.setIsattend("2");
                }

                //根据社团id获取风采图片
                LambdaQueryWrapper<SchoolOrganizationFc> wrapper3 = Wrappers.lambdaQuery();
                wrapper3.eq(SchoolOrganizationFc::getCid,id)
                        .eq(SchoolOrganizationFc::getIsfb,"1")
                        .eq(SchoolOrganizationFc::getDelFlag,"0");
                List<SchoolOrganizationFc> list1 = schoolOrganizationFcService.list(wrapper3);
                ArrayList<String> str = new ArrayList<>();
                if (list1!=null && list1.size()>0){
                    for (int k = 0; k < list1.size(); k++) {
                        String file = list1.get(k).getFile();
                        str.add(file);
                    }
                    String imgs = str.stream().collect(Collectors.joining(","));
                    vo.setImgs(imgs);
                }
                myList.add(vo);
            }
        }
        return AjaxResult.success(myList);
    }

    /**
     * 根据id获取社团信息详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        SchoolOrganizationInfo info = schoolOrganizationInfoService.getById(id);
        SchoolOrganizationInfoVo vo = new SchoolOrganizationInfoVo();
        BeanUtils.copyProperties(info,vo);
        //根据社团id获取风采图片
        LambdaQueryWrapper<SchoolOrganizationFc> wrapper3 = Wrappers.lambdaQuery();
        wrapper3.eq(SchoolOrganizationFc::getCid,id)
                .eq(SchoolOrganizationFc::getIsfb,"1")
                .eq(SchoolOrganizationFc::getDelFlag,"0");
        List<SchoolOrganizationFc> list1 = schoolOrganizationFcService.list(wrapper3);
        ArrayList<String> str = new ArrayList<>();
        if (list1!=null && list1.size()>0){
            for (int k = 0; k < list1.size(); k++) {
                String file = list1.get(k).getFile();
                str.add(file);
            }
            String imgs = str.stream().collect(Collectors.joining(","));
            vo.setImgs(imgs);
        }
        return AjaxResult.success(vo);
    }

    /**
     * 通过当前登录人查询当前社团的报名情况
     * */
    @GetMapping("/search")
    public AjaxResult search (WxOrganizationSigninVo vo){
        Long userId = userInfoUtil.getMpLoginUser().getUserId();
        //根据当前登录人 查询当前社团的报名状态
        LambdaQueryWrapper<SchoolOrganizationSignin> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SchoolOrganizationSignin::getUserId,userId)
                .eq(SchoolOrganizationSignin::getCid,vo.getCid())
                .eq(SchoolOrganizationSignin::getDelFlag,"0");
        SchoolOrganizationSignin one = schoolOrganizationSigninService.getOne(wrapper);
        if (one==null){
            //根据studentId 获取当前登录人信息 返回给前端
            Long studentId = userInfoUtil.getMpLoginUser().getStudentId();
            LambdaQueryWrapper<SchoolStudent> wrapper2 = Wrappers.lambdaQuery();
            wrapper2.eq(SchoolStudent::getId,studentId).eq(SchoolStudent::getDelFlag,"0");
            SchoolStudent ss = schoolStudent.getOne(wrapper2);
            //查询学生班级
            LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
            Long classId = ss.getClassId();
            lqw.eq(SchoolClass::getId,classId).eq(SchoolClass::getDelFlag,"0");
            SchoolClass sc = schoolClass.getOne(lqw);
            Long gradeId = sc.getGradeId();
            //查询级部
            LambdaQueryWrapper<SchoolGrade> jb = new LambdaQueryWrapper<>();
            jb.eq(SchoolGrade::getId,gradeId).eq(SchoolGrade::getDelFlag,"0");
            SchoolGrade grade = schoolGrade.getOne(jb);
            SchoolOrganizationSignin sos = new SchoolOrganizationSignin();
            sos.setGrade(grade.getGradeName());
            sos.setClasses(sc.getClassName());
            sos.setName(ss.getStudentName());
            String sex = ss.getSex();
            if (StringUtils.equals(sex,"0")){
                sos.setSex("男");
            }else {
                sos.setSex("女");
            }
            return AjaxResult.success(sos);
        }
        return AjaxResult.success(one);
    }

    /**
     * 新增社团报名或重新报名
     */
    @PostMapping
    public AjaxResult add(@RequestBody SchoolOrganizationSignin schoolOrganizationSignin)
    {
        //判断cid和userid是否存在 如果存在则先删除 再添加
        LambdaQueryWrapper<SchoolOrganizationSignin> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SchoolOrganizationSignin::getCid,schoolOrganizationSignin.getCid());
        wrapper.eq(SchoolOrganizationSignin::getUserId,schoolOrganizationSignin.getUserId());
        SchoolOrganizationSignin one = schoolOrganizationSigninService.getOne(wrapper);
        if (one!=null){
            schoolOrganizationSigninService.removeById(one.getId());
        }
        schoolOrganizationSignin.setStatus("1"); //适配重新报名的情况
        return toAjax(schoolOrganizationSigninService.save(schoolOrganizationSignin));
    }



}
