package yangtz.cs.liu.wechat.controller.message;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.message.SchoolMessageParentsPushs;
import yangtz.cs.liu.campus.domain.message.SchoolMessageParentsPushsDetails;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePushDetails;
import yangtz.cs.liu.campus.service.message.ISchoolMessageParentsPushsDetailsService;
import yangtz.cs.liu.campus.service.message.ISchoolMessageParentsPushsService;
import yangtz.cs.liu.wechat.vo.message.ParentPushVO;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;


@RestController
@RequestMapping("/wx/parentMessage")
public class WxSchoolParentPushsController extends BaseController {
    @Autowired
    private ISchoolMessageParentsPushsService parentsPushsService;
    @Autowired
    private ISchoolMessageParentsPushsDetailsService detailsService;

    @Autowired
    private UserInfoUtil userInfoUtil;

    /**
     *家长端消息列表
     *
     * @param pushVO
     * @return
     */
    @GetMapping("/parentPushList/{userId}")
    public TableDataInfo parentPushList(@PathVariable("userId")Long userId, ParentPushVO pushVO) {
        startPage();
        List<ParentPushVO> list = parentsPushsService.parentPushList(userId,pushVO);
        return getDataTable(list);
    }

    /**
     * 查询详情
     * @param id
     * @return
     */
    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(parentsPushsService.getById(id));
    }

    /**
     * 修改阅读状态(0未读，1已读)
     * @param id 代表的是推送的id 也就是pushId
     * @return
     */
    @PutMapping("/changeStatus/{id}")
    public AjaxResult changeState(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolMessageParentsPushsDetails> luw = new LambdaUpdateWrapper<>();
        Long userId = userInfoUtil.getMpLoginUser().getUserId();
        luw
                .eq(SchoolMessageParentsPushsDetails::getPushId, id)
                .eq(isNotNull(userId), SchoolMessageParentsPushsDetails::getUserId, userId)
                .set(SchoolMessageParentsPushsDetails::getStatus, "1");
        return toAjax(detailsService.update(luw));
    }
}
