package yangtz.cs.liu.wechat.controller.message;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.message.SchoolMessageParentsPushs;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePush;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePushDetails;
import yangtz.cs.liu.campus.service.message.ISchoolMessagePushDetailsService;
import yangtz.cs.liu.campus.service.message.ISchoolMessagePushService;
import yangtz.cs.liu.wechat.vo.message.MessagePushVO;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

@RestController
@RequestMapping("/wx/message")
public class WxSchoolMessagePushController extends BaseController {
    @Autowired
    ISchoolMessagePushService schoolMessagePushService;
    @Autowired
    ISchoolMessagePushDetailsService detailsService;

    @Autowired
    private UserInfoUtil userInfoUtil;

    /**
     * 教师端消息列表
     *
     * @param messagePushVO
     * @return
     */
    @GetMapping("/teacherPushList/{userId}")
    public TableDataInfo teacherPushList(@PathVariable("userId") Long userId, MessagePushVO messagePushVO) {
        startPage();
        List<MessagePushVO> list = schoolMessagePushService.teacherPushList(userId,messagePushVO);
        return getDataTable(list);
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolMessagePushService.getById(id));
    }

    /**
     * 修改阅读状态(0未读，1已读)
     * @param id 代表的是推送的id 也就是pushId
     * @return
     */
    @PutMapping("/changeStatus/{id}")
    public AjaxResult changeState(@PathVariable("id") Long id) {
        LambdaUpdateWrapper<SchoolMessagePushDetails> luw = new LambdaUpdateWrapper<>();
        Long userId = userInfoUtil.getMpLoginUser().getUserId();
        luw
                .eq(SchoolMessagePushDetails::getPushId, id)
                .eq(isNotNull(userId),SchoolMessagePushDetails::getUserId,userId)
                .set(SchoolMessagePushDetails::getStatus, "1");
        return toAjax(detailsService.update(luw));
    }

}
